/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class CognitiveComplexityVisitor
extends BaseTreeVisitor {
    private final List<JavaFileScannerContext.Location> locations = new ArrayList<JavaFileScannerContext.Location>();
    private final Set<Tree> ignored = new HashSet<Tree>();
    private int complexity = 0;
    private int nesting = 1;
    private boolean ignoreNesting = false;

    private CognitiveComplexityVisitor() {
    }

    public static Result methodComplexity(MethodTree methodTree) {
        if (CognitiveComplexityVisitor.shouldAnalyzeMethod(methodTree)) {
            CognitiveComplexityVisitor visitor = new CognitiveComplexityVisitor();
            methodTree.accept(visitor);
            return new Result(visitor.complexity, visitor.locations);
        }
        return Result.empty();
    }

    public static int compilationUnitComplexity(CompilationUnitTree cut) {
        class CompilationUnitVisitor
        extends BaseTreeVisitor {
            private int cutComplexity = 0;

            CompilationUnitVisitor() {
            }

            @Override
            public void visitMethod(MethodTree tree) {
                this.cutComplexity += CognitiveComplexityVisitor.methodComplexity((MethodTree)tree).complexity;
                super.visitMethod(tree);
            }

            @Override
            public void visitBlock(BlockTree tree) {
                if (tree.is(Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER)) {
                    CognitiveComplexityVisitor visitor = new CognitiveComplexityVisitor();
                    tree.accept(visitor);
                    this.cutComplexity += visitor.complexity;
                }
                super.visitBlock(tree);
            }
        }
        CompilationUnitVisitor compilationUnitVisitor = new CompilationUnitVisitor();
        cut.accept(compilationUnitVisitor);
        return compilationUnitVisitor.cutComplexity;
    }

    private static boolean shouldAnalyzeMethod(MethodTree methodTree) {
        return methodTree.block() != null && !CognitiveComplexityVisitor.memberOfAnonymousClass(methodTree) && !CognitiveComplexityVisitor.isWithinLocalClass(methodTree);
    }

    private static boolean memberOfAnonymousClass(MethodTree methodTree) {
        return ((ClassTree)methodTree.parent()).simpleName() == null;
    }

    private static boolean isWithinLocalClass(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        return symbol != null && symbol.owner().owner().isMethodSymbol();
    }

    private void increaseComplexityByNesting(Tree tree) {
        this.increaseComplexity(tree, this.nesting);
    }

    private void increaseComplexityByOne(Tree tree) {
        this.increaseComplexity(tree, 1);
    }

    private void increaseComplexity(Tree tree, int increase) {
        this.complexity += increase;
        if (this.ignoreNesting) {
            this.locations.add(new JavaFileScannerContext.Location("+1", tree));
            this.ignoreNesting = false;
        } else if (!this.ignored.contains(tree)) {
            String message = "+" + increase;
            if (increase > 1) {
                message = message + " (incl " + (increase - 1) + " for nesting)";
            }
            this.locations.add(new JavaFileScannerContext.Location(message, tree));
        }
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        boolean elseStatementNotIF;
        this.increaseComplexityByNesting(tree.ifKeyword());
        this.scan(tree.condition());
        ++this.nesting;
        this.scan(tree.thenStatement());
        --this.nesting;
        boolean bl = elseStatementNotIF = tree.elseStatement() != null && !tree.elseStatement().is(Tree.Kind.IF_STATEMENT);
        if (elseStatementNotIF) {
            this.increaseComplexityByOne(tree.elseKeyword());
            ++this.nesting;
        } else if (tree.elseStatement() != null) {
            this.ignoreNesting = true;
            this.complexity -= this.nesting - 1;
        }
        this.scan(tree.elseStatement());
        if (elseStatementNotIF) {
            --this.nesting;
        }
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resourceList());
        this.scan(tree.block());
        tree.catches().forEach(c -> this.increaseComplexityByNesting(c.catchKeyword()));
        ++this.nesting;
        this.scan(tree.catches());
        --this.nesting;
        this.scan(tree.finallyBlock());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.increaseComplexityByNesting(tree.forKeyword());
        ++this.nesting;
        super.visitForStatement(tree);
        --this.nesting;
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.increaseComplexityByNesting(tree.forKeyword());
        ++this.nesting;
        super.visitForEachStatement(tree);
        --this.nesting;
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.increaseComplexityByNesting(tree.whileKeyword());
        ++this.nesting;
        super.visitWhileStatement(tree);
        --this.nesting;
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.increaseComplexityByNesting(tree.doKeyword());
        ++this.nesting;
        super.visitDoWhileStatement(tree);
        --this.nesting;
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.increaseComplexityByNesting(tree.questionToken());
        ++this.nesting;
        super.visitConditionalExpression(tree);
        --this.nesting;
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.increaseComplexityByNesting(tree.switchKeyword());
        ++this.nesting;
        super.visitSwitchStatement(tree);
        --this.nesting;
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        if (tree.label() != null) {
            this.increaseComplexityByOne(tree.breakKeyword());
        }
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        if (tree.label() != null) {
            this.increaseComplexityByOne(tree.continueKeyword());
        }
        super.visitContinueStatement(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        ++this.nesting;
        super.visitClass(tree);
        --this.nesting;
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        ++this.nesting;
        super.visitLambdaExpression(lambdaExpressionTree);
        --this.nesting;
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR) && !this.ignored.contains(tree)) {
            List<BinaryExpressionTree> flattenedLogicalExpressions = this.flattenLogicalExpression(tree).toList();
            BinaryExpressionTree previous = null;
            for (BinaryExpressionTree current : flattenedLogicalExpressions) {
                if (previous == null || !previous.is(current.kind())) {
                    this.increaseComplexityByOne(current.operatorToken());
                }
                previous = current;
            }
        }
        super.visitBinaryExpression(tree);
    }

    private Stream<BinaryExpressionTree> flattenLogicalExpression(ExpressionTree expression) {
        if (expression.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            this.ignored.add(expression);
            BinaryExpressionTree binaryExpr = (BinaryExpressionTree)expression;
            ExpressionTree left = ExpressionUtils.skipParentheses(binaryExpr.leftOperand());
            ExpressionTree right = ExpressionUtils.skipParentheses(binaryExpr.rightOperand());
            return Stream.concat(Stream.concat(this.flattenLogicalExpression(left), Stream.of(binaryExpr)), this.flattenLogicalExpression(right));
        }
        return Stream.empty();
    }

    public static class Result {
        private static final Result EMPTY = new Result(0, Collections.emptyList());
        public final int complexity;
        public final List<JavaFileScannerContext.Location> locations;

        public Result(int complexity, List<JavaFileScannerContext.Location> locations) {
            this.complexity = complexity;
            this.locations = locations;
        }

        public static Result empty() {
            return EMPTY;
        }
    }
}

