/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.java.AnalysisException;
import org.sonar.java.AnalysisWarningsWrapper;
import org.sonar.java.classpath.AbstractClasspath;

public class ClasspathForMain
extends AbstractClasspath {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathForMain.class);
    private final AnalysisWarningsWrapper analysisWarnings;
    private boolean hasSuspiciousEmptyLibraries = false;
    private boolean alreadyReported = false;

    public ClasspathForMain(Configuration settings, FileSystem fs, AnalysisWarningsWrapper analysisWarnings) {
        super(settings, fs, InputFile.Type.MAIN);
        this.analysisWarnings = analysisWarnings;
    }

    public ClasspathForMain(Configuration settings, FileSystem fs) {
        this(settings, fs, AnalysisWarningsWrapper.NOOP_ANALYSIS_WARNINGS);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.validateLibraries = this.fs.hasFiles(this.fs.predicates().all());
            this.initialized = true;
            this.binaries.addAll(this.getFilesFromProperty("sonar.java.binaries"));
            LinkedHashSet<File> libraries = new LinkedHashSet<File>(this.getJdkJars());
            Set<File> extraLibraries = this.getFilesFromProperty("sonar.java.libraries");
            ClasspathForMain.logResolvedFiles("sonar.java.libraries", extraLibraries);
            libraries.addAll(extraLibraries);
            if (this.binaries.isEmpty() && libraries.isEmpty() && this.useDeprecatedProperties()) {
                throw new AnalysisException("sonar.binaries and sonar.libraries are not supported since version 4.0 of the SonarSource Java Analyzer, please use sonar.java.binaries and sonar.java.libraries instead");
            }
            boolean bl = this.hasSuspiciousEmptyLibraries = libraries.isEmpty() && this.hasJavaSources();
            if (this.binaries.isEmpty() && this.hasMoreThanOneJavaFile()) {
                if (this.isSonarLint()) {
                    LOG.warn("sonar.java.binaries is empty, please double check your configuration");
                } else {
                    throw new AnalysisException("Your project contains .java files, please provide compiled classes with sonar.java.binaries property, or exclude them from the analysis with sonar.exclusions property.");
                }
            }
            this.elements.addAll(this.binaries);
            this.elements.addAll(libraries);
        }
    }

    protected boolean isSonarLint() {
        return false;
    }

    private boolean useDeprecatedProperties() {
        return ClasspathForMain.isNotNullOrEmpty(this.settings.get("sonar.binaries").orElse(null)) && ClasspathForMain.isNotNullOrEmpty(this.settings.get("sonar.libraries").orElse(null));
    }

    private static boolean isNotNullOrEmpty(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    @Override
    public void logSuspiciousEmptyLibraries() {
        if (this.hasSuspiciousEmptyLibraries && !this.alreadyReported) {
            String warning = String.format("Dependencies/libraries were not provided for analysis of %s files. The '%s' property is empty. Verify your configuration, as you might end up with less precise results.", "SOURCE", "sonar.java.libraries");
            LOG.warn(warning);
            this.analysisWarnings.addUnique(warning);
            this.alreadyReported = true;
        }
    }
}

