/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.Version;

public record VersionImpl(Integer major, Integer minor, @Nullable Integer patch, @Nullable String qualifier) implements Comparable<Version>,
Version
{
    public static String VERSION_REGEX = "([0-9]+).([0-9]+)(.[0-9]+)?([^0-9].*)?";
    private static final Pattern VERSION_PATTERN = Pattern.compile(VERSION_REGEX);

    public static VersionImpl matcherToVersion(Matcher matcher) {
        return new VersionImpl(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3) != null ? Integer.valueOf(Integer.parseInt(matcher.group(3).substring(1))) : null, matcher.group(4));
    }

    public static VersionImpl parse(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (matcher.matches()) {
            return VersionImpl.matcherToVersion(matcher);
        }
        throw new IllegalArgumentException("Not a valid version string: " + versionString);
    }

    @Override
    public int compareTo(Version o) {
        if (!Objects.equals(this.major, o.major())) {
            return this.major - o.major();
        }
        if (!Objects.equals(this.minor, o.minor())) {
            return this.minor - o.minor();
        }
        if (!Objects.equals(this.patch, o.patch())) {
            if (this.patch == null || o.patch() == null) {
                return 0;
            }
            return this.patch - o.patch();
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major()) && Objects.equals(this.minor, version.minor()) && Objects.equals(this.patch, version.patch()) && Objects.equals(this.qualifier, version.qualifier());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.qualifier);
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + (String)(this.patch == null ? "" : "." + this.patch) + (this.qualifier == null ? "" : this.qualifier);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    @Override
    public boolean isLowerThanOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    public boolean isLowerThan(Version version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(String version) {
        return this.isGreaterThanOrEqualTo(VersionImpl.parse(version));
    }

    @Override
    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(VersionImpl.parse(version));
    }

    @Override
    public boolean isLowerThanOrEqualTo(String version) {
        return this.isLowerThanOrEqualTo(VersionImpl.parse(version));
    }

    @Override
    public boolean isLowerThan(String version) {
        return this.isLowerThan(VersionImpl.parse(version));
    }
}

