/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.location.InternalPosition;
import org.sonar.plugins.java.api.location.Range;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class InternalSyntaxTrivia
extends JavaTree
implements SyntaxTrivia {
    private final SyntaxTrivia.CommentKind commentKind;
    private final String comment;
    @Nonnull
    private final Range range;

    public InternalSyntaxTrivia(SyntaxTrivia.CommentKind commentKind, String comment, int line, int columnOffset) {
        boolean validKind;
        this.commentKind = commentKind;
        this.comment = comment;
        boolean mayHaveLineBreaks = commentKind != SyntaxTrivia.CommentKind.LINE;
        this.range = mayHaveLineBreaks ? Range.at(InternalPosition.atOffset(line, columnOffset), comment) : Range.at(InternalPosition.atOffset(line, columnOffset), comment.length());
        switch (commentKind) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LINE: {
                boolean bl = comment.startsWith("//");
                break;
            }
            case BLOCK: {
                boolean bl;
                if (comment.startsWith("/*") && comment.endsWith("*/")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case JAVADOC: {
                boolean bl;
                if (comment.startsWith("/**") && comment.endsWith("*/")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MARKDOWN: {
                boolean bl = validKind = comment.startsWith("///");
            }
        }
        if (!validKind) {
            throw new IllegalArgumentException("Invalid comment kind: " + String.valueOf((Object)commentKind) + " for comment: " + comment);
        }
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public String commentContent() {
        return switch (this.commentKind) {
            default -> throw new IncompatibleClassChangeError();
            case SyntaxTrivia.CommentKind.LINE -> this.comment.substring(2);
            case SyntaxTrivia.CommentKind.BLOCK -> this.comment.substring(2, this.comment.length() - 2);
            case SyntaxTrivia.CommentKind.JAVADOC -> this.comment.substring(3, this.comment.length() - 2);
            case SyntaxTrivia.CommentKind.MARKDOWN -> this.comment.substring(3).replaceAll("\\R[ \t\f]*+///", "\n");
        };
    }

    @Override
    public SyntaxTrivia.CommentKind commentKind() {
        return this.commentKind;
    }

    @Override
    public boolean isComment(SyntaxTrivia.CommentKind kind) {
        return this.commentKind == kind;
    }

    @Override
    public boolean isComment(SyntaxTrivia.CommentKind ... kinds) {
        for (SyntaxTrivia.CommentKind kind : kinds) {
            if (this.commentKind != kind) continue;
            return true;
        }
        return false;
    }

    @Override
    public int startLine() {
        return this.range.start().line();
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TRIVIA;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<Tree> children() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
    }

    @Override
    public int getLine() {
        return this.range.start().line();
    }

    @Override
    public int column() {
        return this.range.start().columnOffset();
    }

    @Override
    @Nonnull
    public Range range() {
        return this.range;
    }
}

