/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class TypeParameterTreeImpl
extends JavaTree
implements TypeParameterTree {
    private final IdentifierTreeImpl identifier;
    @Nullable
    private final SyntaxToken extendsToken;
    private final QualifiedIdentifierListTreeImpl bounds;
    @Nullable
    ITypeBinding typeBinding;

    public TypeParameterTreeImpl(IdentifierTreeImpl identifier) {
        this(identifier, null, QualifiedIdentifierListTreeImpl.emptyList());
    }

    public TypeParameterTreeImpl(IdentifierTreeImpl identifier, @Nullable InternalSyntaxToken extendsToken, QualifiedIdentifierListTreeImpl bounds) {
        this.identifier = identifier;
        this.extendsToken = extendsToken;
        this.bounds = bounds;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParameter(this);
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public SyntaxToken extendToken() {
        return this.extendsToken;
    }

    @Override
    public ListTree<TypeTree> bounds() {
        return this.bounds;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TYPE_PARAMETER;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        list.add(this.identifier);
        if (this.extendsToken != null) {
            list.add(this.extendsToken);
            list.add(this.bounds);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Symbol symbol() {
        return this.typeBinding != null ? this.root.sema.typeSymbol(this.typeBinding) : Symbol.UNKNOWN_SYMBOL;
    }
}

