/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.location;

import javax.annotation.Nullable;
import org.sonar.plugins.java.api.location.Position;

public class InternalPosition
implements Position {
    private final int line;
    private final int column;

    public InternalPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public static Position atOffset(int line, int columnOffset) {
        return new InternalPosition(line, columnOffset + 1);
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int lineOffset() {
        return this.line - 1;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int columnOffset() {
        return this.column - 1;
    }

    @Override
    public int compareTo(Position o) {
        return this.line == o.line() ? Integer.compare(this.column, o.column()) : Integer.compare(this.line, o.line());
    }

    @Override
    public boolean isBefore(Position other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean isAfter(Position other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public Position relativeTo(Position startPosition) {
        if (this.line == 1) {
            return new InternalPosition(this.line + startPosition.lineOffset(), this.column + startPosition.columnOffset());
        }
        return new InternalPosition(this.line + startPosition.lineOffset(), this.column);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPosition that = (InternalPosition)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return 31 * this.line + this.column;
    }

    public String toString() {
        return this.line + ":" + this.column;
    }
}

