/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.previous.core.internal.analysis;

import java.util.ArrayList;
import java.util.Collection;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.previous.core.internal.analysis.CounterImpl;
import org.jacoco.previous.core.internal.analysis.SourceNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCoverageImpl
extends SourceNodeImpl
implements IClassCoverage {
    private final long id;
    private final boolean noMatch;
    private final String signature;
    private final String superName;
    private final String[] interfaces;
    private final Collection<IMethodCoverage> methods;
    private String sourceFileName;

    public ClassCoverageImpl(String name, long id, boolean noMatch, String signature, String superName, String[] interfaces) {
        super(ICoverageNode.ElementType.CLASS, name);
        this.id = id;
        this.noMatch = noMatch;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = interfaces;
        this.methods = new ArrayList<IMethodCoverage>();
        this.classCounter = CounterImpl.COUNTER_1_0;
    }

    public void addMethod(IMethodCoverage method) {
        this.methods.add(method);
        this.increment((ISourceNode)method);
        if (this.methodCounter.getCoveredCount() > 0) {
            this.classCounter = CounterImpl.COUNTER_0_1;
        }
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public long getId() {
        return this.id;
    }

    public boolean isNoMatch() {
        return this.noMatch;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public String getPackageName() {
        int pos = this.getName().lastIndexOf(47);
        return pos == -1 ? "" : this.getName().substring(0, pos);
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public Collection<IMethodCoverage> getMethods() {
        return this.methods;
    }
}

