/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.sonar.java.AnalysisException;
import org.sonar.plugins.jacoco.JaCoCoExtensions;

public class JacocoReportReader {
    @Nullable
    private final File jacocoExecutionData;

    public JacocoReportReader(@Nullable File jacocoExecutionData) {
        JacocoReportReader.checkCurrentReportFormat(jacocoExecutionData);
        this.jacocoExecutionData = jacocoExecutionData;
    }

    public JacocoReportReader readJacocoReport(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoStore) {
        if (this.jacocoExecutionData == null) {
            return this;
        }
        JaCoCoExtensions.LOG.info("Analysing {}", (Object)this.jacocoExecutionData);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.jacocoExecutionData));){
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)inputStream);
            reader.setSessionInfoVisitor(sessionInfoStore);
            reader.setExecutionDataVisitor(executionDataVisitor);
            reader.read();
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read %s", this.jacocoExecutionData.getAbsolutePath()), (Throwable)e);
        }
        return this;
    }

    private static void checkCurrentReportFormat(@Nullable File jacocoExecutionData) {
        if (jacocoExecutionData == null) {
            return;
        }
        try (DataInputStream dis = new DataInputStream(new FileInputStream(jacocoExecutionData));){
            byte firstByte = dis.readByte();
            Preconditions.checkState((firstByte == 1 ? 1 : 0) != 0);
            Preconditions.checkState((dis.readChar() == '\uc0c0' ? 1 : 0) != 0);
            char version = dis.readChar();
            if (version != ExecutionDataWriter.FORMAT_VERSION) {
                throw new AnalysisException("You are not using the latest JaCoCo binary format version, please consider upgrading to latest JaCoCo version.");
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new AnalysisException(String.format("Unable to read %s to determine JaCoCo binary format.", jacocoExecutionData.getAbsolutePath()), (Throwable)e);
        }
    }

    public CoverageBuilder analyzeFiles(ExecutionDataStore executionDataStore, Collection<File> classFiles) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        for (File classFile : classFiles) {
            JacocoReportReader.analyzeClassFile(analyzer, classFile);
        }
        JacocoReportReader.logNoMatchClasses(coverageBuilder.getNoMatchClasses());
        return coverageBuilder;
    }

    private static void logNoMatchClasses(Collection<IClassCoverage> noMatchClasses) {
        if (noMatchClasses.isEmpty()) {
            return;
        }
        JaCoCoExtensions.LOG.warn("The following class(es) did not match with execution data:");
        for (IClassCoverage iClassCoverage : noMatchClasses) {
            JaCoCoExtensions.LOG.warn(String.format("> '%s'", iClassCoverage.getName()));
        }
        JaCoCoExtensions.LOG.warn("In order to have accurate coverage measures, the same class files must be used as at runtime for report generation.");
    }

    private static void analyzeClassFile(Analyzer analyzer, File classFile) {
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            analyzer.analyzeClass((InputStream)inputStream, classFile.getPath());
        }
        catch (IOException e) {
            JaCoCoExtensions.LOG.warn("Exception during analysis of file " + classFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

