/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.jsp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JspCServletContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.jsp.JasperOptions;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.SmapFile;

@ScannerSide
public class Jasper {
    private static final Logger LOG = Loggers.get(Jasper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GeneratedFile> generateFiles(SensorContext sensorContext, List<File> javaClasspath) {
        List<Path> jspFiles = Jasper.jspFiles(sensorContext.fileSystem());
        LOG.debug("Found {} JSP files.", (Object)jspFiles.size());
        if (jspFiles.isEmpty()) {
            return Collections.emptyList();
        }
        Path uriRoot = Jasper.findWebInfParentDirectory(sensorContext.fileSystem()).orElse(sensorContext.fileSystem().baseDir().getAbsoluteFile().toPath());
        LOG.debug("Context root set to {}", (Object)uriRoot);
        Path outputDir = Jasper.outputDir(sensorContext);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = Jasper.initClassLoader(javaClasspath);
            Thread.currentThread().setContextClassLoader(classLoader);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
            ServletContext servletContext = new ServletContext(uriRoot.toUri().toURL(), classLoader);
            JasperOptions options = this.getJasperOptions(outputDir, servletContext);
            JspRuntimeContext runtimeContext = new JspRuntimeContext((javax.servlet.ServletContext)servletContext, (Options)options);
            boolean errorTranspiling = false;
            for (Path jsp : jspFiles) {
                try {
                    Jasper.transpileJsp(jsp, uriRoot, classLoader, servletContext, options, runtimeContext);
                }
                catch (Exception e) {
                    errorTranspiling = true;
                    LOG.debug("Error transpiling " + jsp, (Object)e);
                }
            }
            if (errorTranspiling) {
                LOG.warn("Some JSP pages failed to transpile. Enable debug log for details.");
            }
            Collection<GeneratedFile> collection = Jasper.findGeneratedFiles(outputDir, uriRoot);
            return collection;
        }
        catch (Exception e) {
            LOG.warn("Failed to transpile JSP files.", (Throwable)e);
            List<GeneratedFile> list = Collections.emptyList();
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static void transpileJsp(Path jsp, Path uriRoot, ClassLoader classLoader, JspCServletContext servletContext, JasperOptions options, JspRuntimeContext runtimeContext) throws Exception {
        LOG.debug("Transpiling JSP: {}", (Object)jsp);
        String jspUri = "/" + uriRoot.relativize(jsp).toString().replace('\\', '/');
        JspCompilationContext compilationContext = new JspCompilationContext(jspUri, (Options)options, (javax.servlet.ServletContext)servletContext, null, runtimeContext);
        compilationContext.setClassLoader(classLoader);
        Compiler compiler = compilationContext.createCompiler();
        compiler.compile(false, true);
    }

    JasperOptions getJasperOptions(Path outputDir, JspCServletContext servletContext) {
        return new JasperOptions(servletContext, outputDir);
    }

    private static Optional<Path> findWebInfParentDirectory(FileSystem fs) {
        FilePredicates predicates = fs.predicates();
        ArrayList inputFiles = new ArrayList();
        fs.inputFiles(predicates.matchesPathPattern("**/WEB-INF/**")).forEach(inputFiles::add);
        if (!inputFiles.isEmpty()) {
            Path path = Paths.get(((InputFile)inputFiles.get(0)).absolutePath(), new String[0]);
            for (Path parent = path.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.endsWith("WEB-INF")) continue;
                return Optional.ofNullable(parent.getParent());
            }
        }
        LOG.debug("WEB-INF directory not found, will use basedir as context root");
        return Optional.empty();
    }

    private static List<Path> jspFiles(FileSystem fs) {
        Iterable inputFiles = fs.inputFiles(fs.predicates().hasLanguage("jsp"));
        return StreamSupport.stream(inputFiles.spliterator(), false).map(InputFile::path).collect(Collectors.toList());
    }

    private static ClassLoader initClassLoader(List<File> classPath) {
        URL[] urls = (URL[])classPath.stream().map(Jasper::toUrl).toArray(URL[]::new);
        return new JasperClassLoader(urls, Jasper.class.getClassLoader());
    }

    private static URL toUrl(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Collection<GeneratedFile> findGeneratedFiles(Path outputDir, Path uriRoot) {
        HashMap generatedFiles = new HashMap();
        try (Stream<Path> fileStream = Jasper.walk(outputDir);){
            fileStream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".smap")).map(p -> SmapFile.fromPath((Path)p, (Path)uriRoot)).forEach(smap -> {
                GeneratedFile generatedFile = generatedFiles.computeIfAbsent(smap.getGeneratedFile(), p -> new GeneratedFile(smap.getGeneratedFile()));
                generatedFile.addSmap(smap);
            });
            LOG.debug("Generated {} Java files.", (Object)generatedFiles.size());
            Collection<GeneratedFile> collection = generatedFiles.values();
            return collection;
        }
    }

    static Path outputDir(SensorContext sensorContext) {
        Path path = sensorContext.fileSystem().workDir().toPath().resolve("jsp");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create output dir for jsp files", ex);
        }
        return path;
    }

    static Stream<Path> walk(Path dir) {
        try {
            return Files.walk(dir, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to walk " + dir, e);
        }
    }

    static class ServletContext
    extends JspCServletContext {
        public ServletContext(URL aResourceBaseURL, ClassLoader classLoader) throws JasperException {
            super(null, aResourceBaseURL, classLoader, false, true);
        }

        public void log(String message) {
            LOG.debug(message);
        }

        public void log(String message, Throwable exception) {
            LOG.debug(message, (Object)exception);
        }
    }

    private static class JasperClassLoader
    extends URLClassLoader {
        public JasperClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public URL findResource(String name) {
            URL resource = super.findResource(name);
            if (resource == null) {
                resource = ClassLoader.getSystemResource(name);
            }
            return resource;
        }
    }
}

