/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.jsp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Options;
import org.apache.jasper.TrimSpacesOption;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TldCache;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.sonar.java.AnalysisException;
import org.xml.sax.SAXException;

class JasperOptions
implements Options {
    static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private final Path outputDir;
    private final TagPluginManager tagPluginManager;
    private final TldCache tldCache;
    private final JspConfig jspConfig;

    JasperOptions(JspCServletContext context, Path outputDir) {
        this(context, outputDir, new TldScanner((ServletContext)context, false, false, true));
    }

    JasperOptions(JspCServletContext context, Path outputDir, TldScanner tldScanner) {
        this.outputDir = outputDir;
        this.tagPluginManager = new TagPluginManager((ServletContext)context);
        this.tldCache = JasperOptions.initTldCache(context, tldScanner);
        this.jspConfig = new JspConfig((ServletContext)context);
    }

    private static TldCache initTldCache(JspCServletContext context, TldScanner tldScanner) {
        try {
            tldScanner.scan();
            return new TldCache((ServletContext)context, tldScanner.getUriTldResourcePathMap(), tldScanner.getTldResourcePathTaglibXmlMap());
        }
        catch (IOException | SAXException e) {
            throw new AnalysisException("Error scanning for TLD", (Throwable)e);
        }
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return false;
    }

    public boolean getKeepGenerated() {
        return true;
    }

    public boolean isPoolingEnabled() {
        return false;
    }

    public boolean getMappedFile() {
        return false;
    }

    public boolean getClassDebugInfo() {
        return false;
    }

    public int getCheckInterval() {
        return 0;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean getDisplaySourceFragment() {
        return false;
    }

    public boolean isSmapSuppressed() {
        return false;
    }

    public boolean isSmapDumped() {
        return true;
    }

    public TrimSpacesOption getTrimSpaces() {
        return TrimSpacesOption.FALSE;
    }

    public String getIeClassId() {
        return DEFAULT_IE_CLASS_ID;
    }

    public File getScratchDir() {
        return this.outputDir.toFile();
    }

    public String getClassPath() {
        return null;
    }

    public String getCompiler() {
        return null;
    }

    public String getCompilerTargetVM() {
        return null;
    }

    public String getCompilerSourceVM() {
        return null;
    }

    public String getCompilerClassName() {
        return null;
    }

    public TldCache getTldCache() {
        return this.tldCache;
    }

    public String getJavaEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public boolean getFork() {
        return false;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public boolean isXpoweredBy() {
        return false;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public boolean genStringAsCharArray() {
        return false;
    }

    public int getModificationTestInterval() {
        return 0;
    }

    public boolean getRecompileOnFail() {
        return false;
    }

    public boolean isCaching() {
        return false;
    }

    public Map<String, TagLibraryInfo> getCache() {
        return Collections.emptyMap();
    }

    public int getMaxLoadedJsps() {
        return 0;
    }

    public int getJspIdleTimeout() {
        return 0;
    }

    public boolean getStrictQuoteEscaping() {
        return false;
    }

    public boolean getQuoteAttributeEL() {
        return false;
    }
}

