/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.XxeProperty;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2755")
public class XxeProcessingCheck
extends SECheck {
    private static final String BOOLEAN = "boolean";
    private static final String NEW_INSTANCE = "newInstance";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String XML_INPUT_FACTORY = "javax.xml.stream.XMLInputFactory";
    private static final MethodMatchers XML_INPUT_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes(new String[]{"javax.xml.stream.XMLInputFactory"}).names(new String[]{"newInstance", "newFactory"}).withAnyParameters().build();
    private static final String DOCUMENT_BUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final MethodMatchers DOCUMENT_BUILDER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes(new String[]{"javax.xml.parsers.DocumentBuilderFactory"}).names(new String[]{"newInstance"}).withAnyParameters().build();
    private static final String SAX_PARSER_FACTORY = "javax.xml.parsers.SAXParserFactory";
    private static final String SAX_PARSER = "javax.xml.parsers.SAXParser";
    private static final MethodMatchers SAX_PARSER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes(new String[]{"javax.xml.parsers.SAXParserFactory"}).names(new String[]{"newInstance"}).withAnyParameters().build();
    private static final String SCHEMA_FACTORY = "javax.xml.validation.SchemaFactory";
    private static final MethodMatchers SCHEMA_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes(new String[]{"javax.xml.validation.SchemaFactory"}).names(new String[]{"newInstance"}).withAnyParameters().build();
    private static final String VALIDATOR = "javax.xml.validation.Validator";
    private static final String TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final MethodMatchers TRANSFORMER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.transform.TransformerFactory"}).names(new String[]{"newInstance"}).withAnyParameters().build();
    private static final String XML_READER = "org.xml.sax.XMLReader";
    private static final MethodMatchers CREATE_XML_READER = MethodMatchers.create().ofTypes(new String[]{"org.xml.sax.helpers.XMLReaderFactory"}).names(new String[]{"createXMLReader"}).withAnyParameters().build();
    private static final String SAX_BUILDER = "org.jdom2.input.SAXBuilder";
    private static final MethodMatchers SAX_BUILDER_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"org.jdom2.input.SAXBuilder"}).constructor().withAnyParameters().build();
    private static final String SAX_READER = "org.dom4j.io.SAXReader";
    private static final MethodMatchers SAX_READER_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"org.dom4j.io.SAXReader"}).constructor().withAnyParameters().build();
    private static final MethodMatchers NEW_DOCUMENT_BUILDER = MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.parsers.DocumentBuilderFactory"}).names(new String[]{"newDocumentBuilder"}).addWithoutParametersMatcher().build();
    private static final Map<MethodMatchers, Predicate<ConstraintsByDomain>> CONDITIONS_FOR_SECURED_BY_TYPE = MapBuilder.newMap().put((Object)XML_INPUT_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureSupportDtd.SECURED) || c.hasConstraint(XxeProperty.FeatureIsSupportingExternalEntities.SECURED) || c.hasConstraint(XxeEntityResolver.CUSTOM_ENTITY_RESOLVER)).put((Object)DOCUMENT_BUILDER_FACTORY_NEW_INSTANCE, XxeProcessingCheck::documentBuilderFactoryIsSecured).put((Object)NEW_DOCUMENT_BUILDER, c -> c.hasConstraint(XxeEntityResolver.CUSTOM_ENTITY_RESOLVER)).put((Object)SAX_PARSER_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED)).put((Object)SCHEMA_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED)).put((Object)TRANSFORMER_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeStyleSheet.SECURED)).put((Object)CREATE_XML_READER, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED) || c.hasConstraint(XxeEntityResolver.CUSTOM_ENTITY_RESOLVER)).build();
    private static final Map<MethodMatchers, Predicate<ConstraintsByDomain>> CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS = MapBuilder.newMap().put((Object)SAX_BUILDER_CONSTRUCTOR, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeEntityResolver.CUSTOM_ENTITY_RESOLVER)).put((Object)SAX_READER_CONSTRUCTOR, c -> c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED) || c.hasConstraint(XxeEntityResolver.CUSTOM_ENTITY_RESOLVER)).build();
    private static final MethodMatchers FEATURES_AND_PROPERTIES_SETTERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.parsers.DocumentBuilderFactory", "javax.xml.transform.TransformerFactory"}).names(new String[]{"setAttribute"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Object"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.stream.XMLInputFactory", "javax.xml.parsers.SAXParser", "javax.xml.validation.SchemaFactory", "javax.xml.validation.Validator", "org.xml.sax.XMLReader", "org.jdom2.input.SAXBuilder"}).names(new String[]{"setProperty"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Object"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.parsers.DocumentBuilderFactory", "javax.xml.parsers.SAXParserFactory", "org.xml.sax.XMLReader", "org.jdom2.input.SAXBuilder", "org.dom4j.io.SAXReader"}).names(new String[]{"setFeature"}).addParametersMatcher(new String[]{"java.lang.String", "boolean"}).build()});
    private static final String DOCUMENT_BUILDER = "javax.xml.parsers.DocumentBuilder";
    private static final MethodMatchers ENTITY_RESOLVER_SETTERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.xml.sax.XMLReader", "org.jdom2.input.SAXBuilder", "org.dom4j.io.SAXReader", "javax.xml.parsers.DocumentBuilder"}).names(new String[]{"setEntityResolver"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.stream.XMLInputFactory"}).names(new String[]{"setXMLResolver"}).addParametersMatcher(new String[]{"*"}).build()});
    private static final MethodMatchers TRANSFERRING_METHOD_CALLS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"javax.xml.parsers.SAXParserFactory"}).names(new String[]{"newSAXParser"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.xml.validation.SchemaFactory"}).names(new String[]{"newSchema"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.xml.validation.Schema"}).names(new String[]{"newValidator"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.xml.parsers.SAXParser"}).names(new String[]{"getXMLReader"}).withAnyParameters().build()});
    private static final MethodMatchers PARSING_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.parsers.SAXParser", "org.xml.sax.XMLReader", "javax.xml.parsers.DocumentBuilder"}).names(new String[]{"parse"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.transform.TransformerFactory"}).names(new String[]{"newTransformer"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.stream.XMLInputFactory"}).name(n -> n.startsWith("create")).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.validation.Validator"}).names(new String[]{"validate"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.jdom2.input.SAXBuilder"}).names(new String[]{"build"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.dom4j.io.SAXReader"}).names(new String[]{"read"}).withAnyParameters().build()});
    private static final List<XxeProperty> PROPERTIES_TO_CHECK = Arrays.asList(XxeProperty.FeatureSupportDtd.values(), XxeProperty.FeatureIsSupportingExternalEntities.values(), XxeProperty.FeatureDisallowDoctypeDecl.values(), XxeProperty.FeatureExternalGeneralEntities.values(), XxeProperty.FeatureLoadExternalDtd.values(), XxeProperty.AttributeDTD.values(), XxeProperty.AttributeSchema.values(), XxeProperty.AttributeStyleSheet.values()).stream().flatMap(Stream::of).collect(Collectors.toList());
    private static final List<Class<? extends Constraint>> FLOW_CONSTRAINT_DOMAIN = Arrays.asList(XxeProperty.AttributeDTD.class, XxeProperty.AttributeSchema.class, XxeProperty.AttributeStyleSheet.class);

    private static boolean documentBuilderFactoryIsSecured(@Nullable ConstraintsByDomain c) {
        return c == null || c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureLoadExternalDtd.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED);
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    private static ProgramState addNamedConstraint(@Nullable ExpressionTree expressionTree, ProgramState state) {
        Optional value;
        SymbolicValue sv;
        if (expressionTree != null && (sv = state.peekValue()) != null && (value = expressionTree.asConstant(String.class)).isPresent()) {
            for (XxeProperty property : PROPERTIES_TO_CHECK) {
                if (!property.isNamed((String)value.get())) continue;
                return state.addConstraint(sv, property.namedConstraint());
            }
        }
        return state;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ProgramState endState = context.getState();
        if (endState.exitingOnRuntimeException()) {
            return;
        }
        SymbolicValue peek = endState.peekValue();
        if (peek instanceof XxeSymbolicValue) {
            XxeSymbolicValue xxeSV = (XxeSymbolicValue)peek;
            this.reportIfNotSecured(context, xxeSV, endState.getConstraints(xxeSV));
        }
    }

    private void reportIfNotSecured(CheckerContext context, XxeSymbolicValue xxeSV, @Nullable ConstraintsByDomain constraintsByDomain) {
        if (!xxeSV.isField && !XxeProcessingCheck.isSecuredByProperty(xxeSV, constraintsByDomain)) {
            context.reportIssue(xxeSV.init, this, "Disable access to external entities in XML parsing.", FlowComputation.flowWithoutExceptions(context.getNode(), xxeSV, c -> c == XxeProperty.AttributeDTD.UNSECURED || c == XxeProperty.AttributeSchema.UNSECURED || c == XxeProperty.AttributeStyleSheet.UNSECURED, FLOW_CONSTRAINT_DOMAIN, 20));
        }
    }

    private static boolean isSecuredByProperty(XxeSymbolicValue sv, @Nullable ConstraintsByDomain constraintsByDomain) {
        return constraintsByDomain == null || sv.conditionForSecured.test(constraintsByDomain);
    }

    private static class XxeSymbolicValue
    extends SymbolicValue {
        private final Tree init;
        private final Predicate<ConstraintsByDomain> conditionForSecured;
        private boolean isField;

        private XxeSymbolicValue(Tree init, Predicate<ConstraintsByDomain> conditionForSecured) {
            this.init = init;
            this.isField = false;
            this.conditionForSecured = conditionForSecured;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XxeSymbolicValue that = (XxeSymbolicValue)o;
            return this.isField == that.isField && this.init.equals(that.init) && this.conditionForSecured.equals(that.conditionForSecured);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.init, this.conditionForSecured, this.isField);
        }

        public void setField(boolean isField) {
            this.isField = isField;
        }
    }

    private static enum XxeEntityResolver implements Constraint
    {
        CUSTOM_ENTITY_RESOLVER;

    }

    private static enum XxeSensitive implements Constraint
    {
        SENSITIVE;

    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        private PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        public void visitNewClass(NewClassTree newClass) {
            SymbolicValue peek = this.programState.peekValue();
            if (peek != null && CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS.keySet().stream().anyMatch(mm -> mm.matches(newClass))) {
                this.programState = this.programState.addConstraint(peek, XxeSensitive.SENSITIVE);
            }
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            SymbolicValue peek = this.programState.peekValue();
            if (peek != null && CONDITIONS_FOR_SECURED_BY_TYPE.keySet().stream().anyMatch(mm -> mm.matches(mit))) {
                this.programState = this.programState.addConstraint(peek, XxeSensitive.SENSITIVE);
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ProgramState.SymbolicValueSymbol peek = this.programState.peekValueSymbol();
            Symbol symbol = peek.symbol();
            SymbolicValue sv = peek.symbolicValue();
            if (symbol != null && sv instanceof XxeSymbolicValue) {
                ((XxeSymbolicValue)sv).setField(ProgramState.isField(symbol));
            }
            this.programState = XxeProcessingCheck.addNamedConstraint(tree.expression(), this.programState);
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        private PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
            this.context = context;
        }

        public void visitNewClass(NewClassTree newClass) {
            for (Map.Entry entry : CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS.entrySet()) {
                if (!((MethodMatchers)entry.getKey()).matches(newClass)) continue;
                this.constraintManager.setValueFactory(() -> new XxeSymbolicValue((Tree)newClass.identifier(), (Predicate)entry.getValue()));
                break;
            }
        }

        public void visitVariable(VariableTree tree) {
            this.programState = XxeProcessingCheck.addNamedConstraint(tree.initializer(), this.programState);
        }

        private boolean isSecuredDocumentBuilderCreation(MethodInvocationTree mit) {
            ConstraintsByDomain c = this.programState.getConstraints(this.programState.peekValue(mit.arguments().size()));
            return XxeProcessingCheck.documentBuilderFactoryIsSecured(c);
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            SymbolicValue peek;
            for (Map.Entry entry : CONDITIONS_FOR_SECURED_BY_TYPE.entrySet()) {
                if (!((MethodMatchers)entry.getKey()).matches(mit)) continue;
                if (entry.getKey() == NEW_DOCUMENT_BUILDER && this.isSecuredDocumentBuilderCreation(mit)) break;
                this.constraintManager.setValueFactory(() -> new XxeSymbolicValue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (Predicate)entry.getValue()));
                break;
            }
            if (TRANSFERRING_METHOD_CALLS.matches(mit)) {
                this.constraintManager.setValueFactory(() -> this.programState.peekValue(mit.arguments().size()));
            } else if (FEATURES_AND_PROPERTIES_SETTERS.matches(mit)) {
                Arguments arguments = mit.arguments();
                for (XxeProperty property : PROPERTIES_TO_CHECK) {
                    this.programState = this.checkArguments(this.programState, arguments, property);
                }
            } else if (ENTITY_RESOLVER_SETTERS.matches(mit)) {
                this.handleEntityResolver(mit);
            }
            if (PARSING_METHODS.matches(mit) && (peek = this.programState.peekValue(mit.arguments().size())) instanceof XxeSymbolicValue) {
                XxeSymbolicValue xxeSymbolicValue = (XxeSymbolicValue)peek;
                XxeProcessingCheck.this.reportIfNotSecured(this.context, xxeSymbolicValue, this.programState.getConstraints(xxeSymbolicValue));
            }
        }

        private void handleEntityResolver(MethodInvocationTree mit) {
            SymbolicValue mitResultSV = this.programState.peekValue(mit.arguments().size());
            SymbolicValue entityResolverSV = this.programState.peekValue(0);
            this.programState = this.programState.getConstraint(entityResolverSV, ObjectConstraint.class) == ObjectConstraint.NULL ? this.programState.removeConstraintsOnDomain(mitResultSV, XxeEntityResolver.class) : this.programState.addConstraint(mitResultSV, XxeEntityResolver.CUSTOM_ENTITY_RESOLVER);
        }

        private ProgramState checkArguments(ProgramState state, Arguments arguments, XxeProperty property) {
            if (this.isSettingProperty(state, (ExpressionTree)arguments.get(0), property)) {
                ExpressionTree arg1;
                SymbolicValue sv1 = state.peekValue();
                if (property.isSecuring(sv1, arg1 = (ExpressionTree)arguments.get(1))) {
                    return state.addConstraint(state.peekValue(2), property.securedConstraint());
                }
                if (property.isUnsecuring(sv1, arg1)) {
                    return state.addConstraint(state.peekValue(2), property.unsecuredConstraint());
                }
            }
            return state;
        }

        boolean isSettingProperty(ProgramState state, ExpressionTree arg0, XxeProperty property) {
            if (arg0.asConstant(String.class).filter(property::isNamed).isPresent()) {
                return true;
            }
            ConstraintsByDomain constraintsByDomain = state.getConstraints(state.peekValue(1));
            return constraintsByDomain != null && constraintsByDomain.hasConstraint(property.namedConstraint());
        }
    }
}

