/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends SubscriptionVisitor {
    private static final Logger LOG = Loggers.get(SymbolicExecutionVisitor.class);
    @VisibleForTesting
    public final BehaviorCache behaviorCache;
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<SECheck> seChecks) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(seChecks);
        this.behaviorCache = new BehaviorCache();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.behaviorCache.cleanup();
        this.behaviorCache.setFileContext(this);
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        this.execute((MethodTree)tree);
    }

    public void execute(MethodTree methodTree) {
        block6: {
            ExplodedGraphWalker walker = this.getWalker();
            try {
                Symbol.MethodSymbol methodSymbol = methodTree.symbol();
                if (SymbolicExecutionVisitor.methodCanNotBeOverriden(methodSymbol)) {
                    MethodBehavior methodBehavior = this.behaviorCache.methodBehaviorForSymbol(methodSymbol);
                    if (!methodBehavior.isVisited()) {
                        methodBehavior = walker.visitMethod(methodTree, methodBehavior);
                        methodBehavior.completed();
                    }
                } else {
                    walker.visitMethod(methodTree);
                }
            }
            catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStartingStatesException | ExplodedGraphWalker.MaximumStepsReachedException exception) {
                LOG.debug("Could not complete symbolic execution: {}", (Object)exception.getMessage());
                if (LOG.isTraceEnabled()) {
                    StringWriter sw = new StringWriter();
                    exception.printStackTrace(new PrintWriter(sw));
                    LOG.trace(sw.toString());
                }
                if (walker.methodBehavior == null) break block6;
                walker.methodBehavior.visited();
            }
        }
    }

    @VisibleForTesting
    protected ExplodedGraphWalker getWalker() {
        return this.egwFactory.createWalker(this.behaviorCache, this.context);
    }

    public static boolean methodCanNotBeOverriden(Symbol.MethodSymbol methodSymbol) {
        if (JUtils.isNativeMethod((Symbol.MethodSymbol)methodSymbol)) {
            return false;
        }
        return !methodSymbol.isAbstract() && (methodSymbol.isPrivate() || methodSymbol.isFinal() || methodSymbol.isStatic() || methodSymbol.owner().isFinal());
    }
}

