/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3518")
public class DivisionByZeroCheck
extends SECheck {
    private static final String BIG_INTEGER = "java.math.BigInteger";
    private static final String BIG_DECIMAL = "java.math.BigDecimal";
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("A division by zero will occur when invoking method \"%s()\".");
    private static final MethodMatchers.NameBuilder BIG_INTEGER_AND_DECIMAL = MethodMatchers.create().ofTypes(new String[]{"java.math.BigInteger", "java.math.BigDecimal"});
    private static final MethodMatchers BIG_INT_DEC_VALUE_OF = BIG_INTEGER_AND_DECIMAL.names(new String[]{"valueOf"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers BIG_INT_DEC_DIVIDE_REMAINDER = BIG_INTEGER_AND_DECIMAL.names(new String[]{"divide", "remainder", "divideAndRemainder"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers BIG_INT_DEC_MULTIPLY = BIG_INTEGER_AND_DECIMAL.names(new String[]{"multiply"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers BIG_INT_DEC_ADD_SUB = BIG_INTEGER_AND_DECIMAL.names(new String[]{"add", "subtract"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers KEEPING_CONSTRAINTS_WITHOUT_PARAM = BIG_INTEGER_AND_DECIMAL.names(new String[]{"toBigInteger", "toBigIntegerExact", "abs", "byteValueExact", "byteValue", "byteValueExact", "shortValue", "shortValueExact", "doubleValue", "floatValue", "intValue", "intValueExact", "longValue", "longValueExact"}).addParametersMatcher(new String[0]).build();
    private static final MethodMatchers KEEPING_CONSTRAINTS_WITH_ONE_PARAM = BIG_INTEGER_AND_DECIMAL.names(new String[]{"pow", "round", "shiftRight", "shiftLeft"}).addParametersMatcher(new String[]{"*"}).build();
    private final Map<String, Boolean> zeroValuesCache = new HashMap<String, Boolean>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.zeroValuesCache.clear();
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context, this.zeroValuesCache);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            SymbolicValue expression;
            SymbolicValue variable;
            Symbol symbol;
            if (ExpressionUtils.isSimpleAssignment((AssignmentExpressionTree)tree)) {
                symbol = ExpressionUtils.extractIdentifier((AssignmentExpressionTree)tree).symbol();
                variable = this.programState.getValue(symbol);
                expression = this.programState.peekValue();
            } else {
                ProgramState.Pop unstackValue = this.programState.unstackValue(2);
                variable = unstackValue.values.get(1);
                expression = unstackValue.values.get(0);
                symbol = unstackValue.valuesAndSymbols.get(0).symbol();
            }
            this.checkExpression((Tree)tree, variable, expression, symbol);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case REMAINDER: {
                    ProgramState.Pop unstackValue = this.programState.unstackValue(2);
                    this.checkExpression((Tree)tree, unstackValue.values.get(1), unstackValue.values.get(0), unstackValue.valuesAndSymbols.get(0).symbol());
                    break;
                }
            }
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (BIG_INT_DEC_DIVIDE_REMAINDER.matches(tree)) {
                ProgramState.SymbolicValueSymbol rightOp = this.programState.peekValueSymbol();
                this.handleDivide((Tree)tree, this.programState.peekValue(1), rightOp.symbolicValue(), rightOp.symbol());
            } else if (BIG_INT_DEC_ADD_SUB.matches(tree)) {
                this.handlePlusMinus(this.programState.peekValue(1), this.programState.peekValue(0));
            } else if (BIG_INT_DEC_MULTIPLY.matches(tree)) {
                this.handleMultiply(this.programState.peekValue(1), this.programState.peekValue(0));
            } else if (BIG_INT_DEC_VALUE_OF.matches(tree)) {
                ExpressionTree arg = (ExpressionTree)tree.arguments().get(0);
                SymbolicValue sv = this.programState.peekValue(0);
                if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.isZero(sv)) {
                    this.reuseSymbolicValue(sv);
                }
            } else if (KEEPING_CONSTRAINTS_WITHOUT_PARAM.matches(tree)) {
                this.reuseSymbolicValue(this.programState.peekValue(0));
            } else if (KEEPING_CONSTRAINTS_WITH_ONE_PARAM.matches(tree)) {
                this.reuseSymbolicValue(this.programState.peekValue(1));
            }
        }

        private void checkExpression(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp, Symbol rightOpSymbol) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case MULTIPLY_ASSIGNMENT: {
                    this.handleMultiply(leftOp, rightOp);
                    break;
                }
                case PLUS: 
                case MINUS: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: {
                    this.handlePlusMinus(leftOp, rightOp);
                    break;
                }
                case DIVIDE: 
                case REMAINDER: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: {
                    this.handleDivide(tree, leftOp, rightOp, rightOpSymbol);
                    break;
                }
            }
        }

        private boolean isZero(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, ZeroConstraint.ZERO);
        }

        private boolean isNonZero(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, ZeroConstraint.NON_ZERO);
        }

        private boolean hasNoConstraint(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, null);
        }

        private boolean hasConstraint(SymbolicValue symbolicValue, ZeroConstraint constraint) {
            return this.programState.getConstraint(symbolicValue, ZeroConstraint.class) == constraint;
        }

        private void handleMultiply(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? left : right);
            } else if (this.isNonZero(left) && this.isNonZero(right)) {
                this.deferConstraint(ZeroConstraint.NON_ZERO);
            }
        }

        private void handlePlusMinus(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? right : left);
            }
        }

        private void handleDivide(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp, Symbol rightOpSymbol) {
            if (this.isZero(rightOp)) {
                this.context.addExceptionalYield(rightOp, this.programState, "java.lang.ArithmeticException", DivisionByZeroCheck.this);
                this.reportIssue(tree, rightOp, rightOpSymbol);
                this.programState = null;
            } else if (this.isZero(leftOp)) {
                this.reuseSymbolicValue(leftOp);
            } else if (this.isNonZero(leftOp) && this.isNonZero(rightOp)) {
                this.deferConstraint(null);
            } else if (this.hasNoConstraint(rightOp)) {
                ProgramState exceptionalState = this.programState.addConstraint(rightOp, ZeroConstraint.ZERO).addConstraint(rightOp, ObjectConstraint.NOT_NULL);
                this.context.addExceptionalYield(rightOp, exceptionalState, "java.lang.ArithmeticException", DivisionByZeroCheck.this);
                this.programState = this.programState.addConstraintTransitively(rightOp, ZeroConstraint.NON_ZERO);
            }
        }

        private void deferConstraint(@Nullable ZeroConstraint constraint) {
            this.constraintManager.setValueFactory(() -> new DeferredConstraintHolderSV(constraint));
        }

        private void reuseSymbolicValue(final SymbolicValue sv) {
            this.constraintManager.setValueFactory(() -> new DeferredConstraintHolderSV(this.programState.getConstraint(sv, ZeroConstraint.class)){

                @Override
                public SymbolicValue wrappedValue() {
                    return sv.wrappedValue();
                }
            });
        }

        private void reportIssue(Tree tree, SymbolicValue denominator, Symbol denominatorSymbol) {
            ExpressionTree expression = this.getDenominator(tree);
            String operation = tree.is(new Tree.Kind[]{Tree.Kind.REMAINDER, Tree.Kind.REMAINDER_ASSIGNMENT}) ? "modulation" : "division";
            String expressionName = expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? "\"" + ((IdentifierTree)expression).name() + "\"" : "this expression";
            List<Class<? extends Constraint>> domains = Collections.singletonList(ZeroConstraint.class);
            Set<Flow> flows = FlowComputation.flow(this.context.getNode(), denominator, domains, denominatorSymbol, 20).stream().filter(f -> !f.isEmpty()).map(f -> Flow.builder().add(new JavaFileScannerContext.Location("Division by zero.", tree)).addAll((Flow)f).build()).collect(Collectors.toSet());
            this.context.reportIssue((Tree)expression, DivisionByZeroCheck.this, "Make sure " + expressionName + " can't be zero before doing this " + operation + ".", flows);
        }

        private ExpressionTree getDenominator(Tree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER})) {
                return ((BinaryExpressionTree)tree).rightOperand();
            }
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return (ExpressionTree)((MethodInvocationTree)tree).arguments().get(0);
            }
            return ((AssignmentExpressionTree)tree).expression();
        }

        public void visitTypeCast(TypeCastTree tree) {
            Type type = tree.type().symbolType();
            if (type.isPrimitive()) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    this.reuseSymbolicValue(sv);
                } else if (this.isNonZero(sv)) {
                    this.deferConstraint(ZeroConstraint.NON_ZERO);
                }
            }
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
                        this.reuseSymbolicValue(sv);
                    } else {
                        this.deferConstraint(ZeroConstraint.NON_ZERO);
                    }
                } else {
                    this.deferConstraint(null);
                }
            }
        }
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final Map<String, Boolean> zeroValuesCache;

        PostStatementVisitor(CheckerContext context, Map<String, Boolean> zeroValuesCache) {
            super(context.getState());
            this.zeroValuesCache = zeroValuesCache;
        }

        public void visitLiteral(LiteralTree tree) {
            this.handleLiteral(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            ExpressionTree arg;
            if (BIG_INT_DEC_VALUE_OF.matches(tree) && (arg = (ExpressionTree)tree.arguments().get(0)) instanceof LiteralTree) {
                this.handleLiteral((LiteralTree)arg);
                return;
            }
            this.checkDeferredConstraint();
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            IdentifierTree id = tree.identifier();
            Type idType = id.symbolType();
            SymbolicValue sv = this.programState.peekValue();
            if (sv != null && (idType.is(DivisionByZeroCheck.BIG_INTEGER) || idType.is(DivisionByZeroCheck.BIG_DECIMAL))) {
                if ("ZERO".equals(id.name())) {
                    this.addZeroConstraint(sv, ZeroConstraint.ZERO);
                } else {
                    this.addZeroConstraint(sv, ZeroConstraint.NON_ZERO);
                }
            }
            super.visitMemberSelectExpression(tree);
        }

        private void handleLiteral(LiteralTree tree) {
            String value = tree.value();
            SymbolicValue sv = this.programState.peekValue();
            if (tree.is(new Tree.Kind[]{Tree.Kind.CHAR_LITERAL}) && PostStatementVisitor.isNullCharacter(value)) {
                this.addZeroConstraint(sv, ZeroConstraint.ZERO);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL})) {
                this.addZeroConstraint(sv, this.checkZeroLiteral(tree) ? ZeroConstraint.ZERO : ZeroConstraint.NON_ZERO);
            }
        }

        private boolean checkZeroLiteral(LiteralTree literalTree) {
            String value = literalTree.value();
            return this.zeroValuesCache.computeIfAbsent(value, v -> PostStatementVisitor.isZeroLiteral(literalTree, value));
        }

        private static boolean isZeroLiteral(LiteralTree literalTree, String value) {
            if (value.length() == 1) {
                return "0".equals(value);
            }
            int startIndex = 0;
            int endIndex = value.length() - 1;
            switch (literalTree.kind()) {
                case LONG_LITERAL: {
                    endIndex = value.length() - 2;
                }
                case INT_LITERAL: {
                    if (value.charAt(0) != '0' || value.charAt(1) != 'x' && value.charAt(1) != 'X' && value.charAt(1) != 'b' && value.charAt(1) != 'B') break;
                    startIndex = 2;
                    break;
                }
                case FLOAT_LITERAL: {
                    endIndex = value.length() - 2;
                    break;
                }
                case DOUBLE_LITERAL: {
                    if (value.charAt(endIndex) != 'd' && value.charAt(endIndex) != 'D') break;
                    endIndex = value.length() - 2;
                }
            }
            return PostStatementVisitor.isNumberZero(value, startIndex, endIndex);
        }

        private static boolean isNumberZero(String literalValue, int startIndex, int endIndex) {
            for (int i = startIndex; i <= endIndex; ++i) {
                if (literalValue.charAt(i) == '_' || literalValue.charAt(i) == '0' || literalValue.charAt(i) == '.') continue;
                return false;
            }
            return true;
        }

        private static boolean isNullCharacter(String literalValue) {
            return "'\\0'".equals(literalValue) || "'\\u0000'".equals(literalValue);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        public void visitTypeCast(TypeCastTree tree) {
            this.checkDeferredConstraint();
        }

        private void checkDeferredConstraint() {
            SymbolicValue sv = this.programState.peekValue();
            if (sv instanceof DeferredConstraintHolderSV) {
                this.addZeroConstraint(sv, ((DeferredConstraintHolderSV)sv).deferredConstraint);
            }
        }

        private void addZeroConstraint(SymbolicValue sv, @Nullable ZeroConstraint zeroConstraint) {
            this.programState = zeroConstraint == null ? this.programState.removeConstraintsOnDomain(sv, ZeroConstraint.class) : this.programState.addConstraint(sv, zeroConstraint);
        }
    }

    private static class DeferredConstraintHolderSV
    extends SymbolicValue {
        @Nullable
        private final ZeroConstraint deferredConstraint;

        DeferredConstraintHolderSV(@Nullable ZeroConstraint deferredConstraint) {
            this.deferredConstraint = deferredConstraint;
        }
    }

    public static enum ZeroConstraint implements Constraint
    {
        ZERO,
        NON_ZERO;


        @Override
        public boolean hasPreciseValue() {
            return this == ZERO;
        }

        @Override
        public String valueAsString() {
            if (this == ZERO) {
                return "zero";
            }
            return "non-zero";
        }

        @Override
        public boolean isValidWith(@Nullable Constraint constraint) {
            return constraint == null || this == constraint;
        }

        @Override
        @Nullable
        public Constraint copyOver(RelationalSymbolicValue.Kind kind) {
            switch (kind) {
                case EQUAL: 
                case METHOD_EQUALS: {
                    return this;
                }
                case LESS_THAN: 
                case NOT_EQUAL: 
                case NOT_METHOD_EQUALS: {
                    return this.inverse();
                }
            }
            return null;
        }

        @Override
        public Constraint inverse() {
            if (this == ZERO) {
                return NON_ZERO;
            }
            return null;
        }
    }
}

