/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3065")
public class MinMaxRangeCheck
extends SECheck {
    private static final String UPPER = "upper";
    private static final String LOWER = "lower";
    private static final String FLOW_MESSAGE = "Returns the %s bound.";
    private static final String ISSUE_MESSAGE = "Change these chained %s methods invocations, as final results will always be the %s bound.";
    private static final MethodMatchers MIN_MAX_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"min", "max"}).addParametersMatcher(new String[]{"*", "*"}).build();

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        ProgramState programState = context.getState();
        if (!syntaxNode.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return programState;
        }
        MethodInvocationTree mit = (MethodInvocationTree)syntaxNode;
        if (!MIN_MAX_MATCHER.matches(mit)) {
            return programState;
        }
        List<SymbolicValue> args = programState.peekValues(2);
        for (SymbolicValue arg : args) {
            MinMaxRangeConstraint minMaxConstraint = programState.getConstraint(arg, MinMaxRangeConstraint.class);
            NumericalConstraint numericalConstraint = programState.getConstraint(arg, NumericalConstraint.class);
            if (minMaxConstraint != null || numericalConstraint == null) continue;
            programState = programState.addConstraint(arg, new MinMaxRangeConstraint(mit));
        }
        return programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        switch (syntaxNode.kind()) {
            case INT_LITERAL: {
                return MinMaxRangeCheck.handleNumericalLiteral(context, LiteralUtils.intLiteralValue((ExpressionTree)((ExpressionTree)syntaxNode)));
            }
            case LONG_LITERAL: {
                return MinMaxRangeCheck.handleNumericalLiteral(context, LiteralUtils.longLiteralValue((ExpressionTree)((ExpressionTree)syntaxNode)));
            }
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                return MinMaxRangeCheck.handleNumericalLiteral(context, (UnaryExpressionTree)syntaxNode);
            }
            case IDENTIFIER: {
                return MinMaxRangeCheck.handleNumericalConstant(context, (IdentifierTree)syntaxNode);
            }
            case METHOD_INVOCATION: {
                return this.handleMinMaxInvocation(context, (MethodInvocationTree)syntaxNode);
            }
        }
        return context.getState();
    }

    private static ProgramState handleNumericalConstant(CheckerContext context, IdentifierTree syntaxNode) {
        ProgramState programState = context.getState();
        Symbol identifier = syntaxNode.symbol();
        if (!MinMaxRangeCheck.isNumericalConstant(identifier)) {
            return programState;
        }
        SymbolicValue constant = programState.getValue(identifier);
        if (constant == null) {
            return programState;
        }
        NumericalConstraint numericalConstraint = programState.getConstraint(constant, NumericalConstraint.class);
        if (numericalConstraint == null) {
            return JUtils.constantValue((Symbol.VariableSymbol)((Symbol.VariableSymbol)identifier)).filter(Number.class::isInstance).map(Number.class::cast).map(value -> programState.addConstraint(constant, new NumericalConstraint((Number)value))).orElse(programState);
        }
        return programState;
    }

    private ProgramState handleMinMaxInvocation(CheckerContext context, MethodInvocationTree syntaxNode) {
        if (!MIN_MAX_MATCHER.matches(syntaxNode)) {
            return context.getState();
        }
        ProgramState programState = context.getState();
        ProgramState psBeforeInvocation = context.getNode().programState;
        List<SymbolicValue> args = psBeforeInvocation.peekValues(2);
        List<ConstraintsByDomain> constraintsByArgs = args.stream().map(programState::getConstraints).collect(Collectors.toList());
        this.checkRangeInconsistencies(context, syntaxNode, constraintsByArgs);
        return context.getState();
    }

    private void checkRangeInconsistencies(CheckerContext context, MethodInvocationTree syntaxNode, List<ConstraintsByDomain> constraintsByArgs) {
        Number upperBound;
        Number lowerBound;
        int comparedValue;
        MinMaxValue arg0MinMaxValue = MinMaxValue.fromConstraints(constraintsByArgs.get(0));
        MinMaxValue arg1MinMaxValue = MinMaxValue.fromConstraints(constraintsByArgs.get(1));
        if (arg0MinMaxValue != null && arg1MinMaxValue != null && arg0MinMaxValue.op != arg1MinMaxValue.op && (comparedValue = MinMaxRangeCheck.compareNumbers(lowerBound = arg0MinMaxValue.op == Operation.MAX ? (Number)arg0MinMaxValue.value : (Number)arg1MinMaxValue.value, upperBound = arg0MinMaxValue.op == Operation.MIN ? (Number)arg0MinMaxValue.value : (Number)arg1MinMaxValue.value)) > 0) {
            String secondOpMessage;
            String firstOpMessage;
            String issueMessage;
            if ("min".equals(syntaxNode.methodSymbol().name())) {
                issueMessage = String.format(ISSUE_MESSAGE, "min/max", LOWER);
                firstOpMessage = String.format(FLOW_MESSAGE, UPPER);
                secondOpMessage = String.format(FLOW_MESSAGE, LOWER);
            } else {
                issueMessage = String.format(ISSUE_MESSAGE, "max/min", UPPER);
                firstOpMessage = String.format(FLOW_MESSAGE, LOWER);
                secondOpMessage = String.format(FLOW_MESSAGE, UPPER);
            }
            MethodInvocationTree flowTree = syntaxNode == arg0MinMaxValue.syntaxNode ? arg1MinMaxValue.syntaxNode : arg0MinMaxValue.syntaxNode;
            Set<Flow> flow = Collections.singleton(Flow.builder().add(new JavaFileScannerContext.Location(secondOpMessage, (Tree)syntaxNode)).add(new JavaFileScannerContext.Location(firstOpMessage, (Tree)flowTree)).build());
            context.reportIssue((Tree)syntaxNode, this, issueMessage, flow);
        }
    }

    private static int compareNumbers(Number n1, Number n2) {
        Double n1Double = n1.doubleValue();
        Double n2Double = n2.doubleValue();
        return n1Double.compareTo(n2Double);
    }

    private static ProgramState handleNumericalLiteral(CheckerContext context, @Nullable Number value) {
        ProgramState programState = context.getState();
        if (value == null) {
            return programState;
        }
        return programState.addConstraint(programState.peekValue(), new NumericalConstraint(value));
    }

    private static ProgramState handleNumericalLiteral(CheckerContext context, UnaryExpressionTree syntaxNode) {
        ProgramState previousPS = context.getNode().programState;
        NumericalConstraint knownNumericalConstraint = previousPS.getConstraint(previousPS.peekValue(), NumericalConstraint.class);
        ProgramState programState = context.getState();
        if (knownNumericalConstraint == null) {
            return programState;
        }
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS})) {
            return programState.addConstraint(programState.peekValue(), knownNumericalConstraint);
        }
        Number value = knownNumericalConstraint.value;
        value = value instanceof Integer ? (Number)(-1 * value.intValue()) : (Number)(value instanceof Long ? (Number)(-1L * value.longValue()) : (Number)(value instanceof Float ? (Number)Float.valueOf(-1.0f * value.floatValue()) : (Number)(-1.0 * value.doubleValue())));
        return programState.addConstraint(programState.peekValue(), new NumericalConstraint(value));
    }

    private static boolean isNumericalConstant(@Nullable Symbol symbol) {
        return symbol != null && MinMaxRangeCheck.isConstant(symbol) && MinMaxRangeCheck.isNumericalPrimitive(symbol);
    }

    private static boolean isNumericalPrimitive(Symbol symbol) {
        Type type = symbol.type();
        return type.isPrimitive() && type.isNumerical();
    }

    private static boolean isConstant(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.isStatic() && symbol.isFinal();
    }

    private static class MinMaxRangeConstraint
    implements Constraint {
        private final Operation op;
        private final MethodInvocationTree syntaxNode;

        MinMaxRangeConstraint(MethodInvocationTree syntaxNode) {
            this.syntaxNode = syntaxNode;
            this.op = "min".equals(syntaxNode.methodSymbol().name()) ? Operation.MIN : Operation.MAX;
        }

        public String toString() {
            return "Range_" + this.op.name();
        }
    }

    private static class NumericalConstraint
    implements Constraint {
        private final Number value;

        NumericalConstraint(Number value) {
            this.value = value;
        }

        public String toString() {
            return "Number(" + String.valueOf(this.value) + ")";
        }
    }

    private static class MinMaxValue {
        private final Number value;
        private final Operation op;
        private final MethodInvocationTree syntaxNode;

        MinMaxValue(NumericalConstraint numericalConstraint, MinMaxRangeConstraint minMaxRangeConstraint) {
            this.value = numericalConstraint.value;
            this.op = minMaxRangeConstraint.op;
            this.syntaxNode = minMaxRangeConstraint.syntaxNode;
        }

        @CheckForNull
        static MinMaxValue fromConstraints(@Nullable ConstraintsByDomain constraints) {
            if (constraints == null) {
                return null;
            }
            Constraint minMaxRangeConstraint = constraints.get(MinMaxRangeConstraint.class);
            Constraint numericalConstraint = constraints.get(NumericalConstraint.class);
            if (minMaxRangeConstraint != null && numericalConstraint != null) {
                return new MinMaxValue((NumericalConstraint)numericalConstraint, (MinMaxRangeConstraint)minMaxRangeConstraint);
            }
            return null;
        }
    }

    private static enum Operation {
        MIN,
        MAX;

    }
}

