/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2637")
public class NonNullSetToNullCheck
extends SECheck {
    private static final String[] JPA_ANNOTATIONS = new String[]{"javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass"};
    private Deque<MethodTree> methodTrees = new ArrayDeque<MethodTree>();

    @Override
    public void init(MethodTree tree, CFG cfg) {
        this.methodTrees.push(tree);
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.methodTrees.pop();
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.methodTrees.pop();
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        MethodTree methodTree = this.methodTrees.peek();
        if (methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !NonNullSetToNullCheck.isDefaultConstructorForJpa(methodTree) && !NonNullSetToNullCheck.callsThisConstructor(methodTree) && !NonNullSetToNullCheck.exitingWithException(context)) {
            ClassTree classTree = (ClassTree)methodTree.parent();
            classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(v -> v.initializer() == null).forEach(v -> this.checkVariable(context, methodTree, v.symbol()));
        }
    }

    private static boolean exitingWithException(CheckerContext context) {
        return context.getState().peekValue() instanceof SymbolicValue.ExceptionalSymbolicValue;
    }

    private static boolean isDefaultConstructorForJpa(MethodTree methodTree) {
        if (!methodTree.block().body().isEmpty()) {
            return false;
        }
        SymbolMetadata symbolMetadata = ((ClassTree)methodTree.parent()).symbol().metadata();
        return Stream.of(JPA_ANNOTATIONS).anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0));
    }

    private static boolean callsThisConstructor(MethodTree constructor) {
        List body = constructor.block().body();
        if (body.isEmpty()) {
            return false;
        }
        StatementTree firstStatement = (StatementTree)body.get(0);
        if (!firstStatement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return false;
        }
        ExpressionTree expression = ((ExpressionStatementTree)firstStatement).expression();
        if (!expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        ExpressionTree methodSelect = ((MethodInvocationTree)expression).methodSelect();
        return ExpressionUtils.isThis((ExpressionTree)methodSelect);
    }

    private void checkVariable(CheckerContext context, MethodTree tree, Symbol symbol) {
        String nonNullAnnotation = NullableAnnotationUtils.nonNullAnnotation(symbol);
        if (nonNullAnnotation == null || nonNullAnnotation.startsWith("javax.validation.constraints.") || symbol.isStatic()) {
            return;
        }
        if (NonNullSetToNullCheck.isUndefinedOrNull(context, symbol)) {
            context.reportIssue((Tree)tree.simpleName(), this, MessageFormat.format("\"{0}\" is marked \"{1}\" but is not initialized in this constructor.", symbol.name(), nonNullAnnotation));
        }
    }

    private static boolean isUndefinedOrNull(CheckerContext context, Symbol symbol) {
        ProgramState programState = context.getState();
        SymbolicValue value = programState.getValue(symbol);
        return value == null;
    }

    private class PreStatementVisitor
    extends AbstractStatementVisitor {
        protected PreStatementVisitor(CheckerContext context) {
            super(context);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (ExpressionUtils.isSimpleAssignment((AssignmentExpressionTree)tree)) {
                IdentifierTree variable = ExpressionUtils.extractIdentifier((AssignmentExpressionTree)tree);
                Symbol symbol = variable.symbol();
                String nonNullAnnotation = NullableAnnotationUtils.nonNullAnnotation(symbol);
                if (nonNullAnnotation == null) {
                    return;
                }
                SymbolicValue assignedValue = this.programState.peekValue();
                ObjectConstraint constraint = this.programState.getConstraint(assignedValue, ObjectConstraint.class);
                if (constraint != null && constraint.isNull()) {
                    this.reportIssue((Tree)tree, "\"{0}\" is marked \"{1}\" but is set to null.", symbol.name(), nonNullAnnotation);
                }
            }
        }

        public void visitNewClass(NewClassTree syntaxTree) {
            Symbol symbol = syntaxTree.constructorSymbol();
            if (symbol.isMethodSymbol()) {
                int peekSize = syntaxTree.arguments().size();
                List argumentValues = ListUtils.reverse(this.programState.peekValues(peekSize));
                this.checkNullArguments((Tree)syntaxTree, (Symbol.MethodSymbol)symbol, argumentValues);
            }
        }

        public void visitMethodInvocation(MethodInvocationTree syntaxTree) {
            Symbol symbol = syntaxTree.symbol();
            if (symbol.isMethodSymbol()) {
                Arguments arguments = syntaxTree.arguments();
                int peekSize = arguments.size() + 1;
                List argumentValues = ListUtils.reverse(this.programState.peekValues(peekSize).subList(0, peekSize - 1));
                ExpressionTree reportTree = syntaxTree.methodSelect();
                if (reportTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    reportTree = ((MemberSelectExpressionTree)reportTree).identifier();
                }
                this.checkNullArguments((Tree)reportTree, (Symbol.MethodSymbol)symbol, argumentValues);
            }
        }

        private void checkNullArguments(Tree syntaxTree, Symbol.MethodSymbol symbol, List<SymbolicValue> argumentValues) {
            int parametersToTest = argumentValues.size();
            if (symbol.parameterTypes().size() < parametersToTest) {
                parametersToTest = symbol.parameterTypes().size() - 1;
            }
            for (int i = 0; i < parametersToTest; ++i) {
                this.checkNullArgument(syntaxTree, symbol, i, argumentValues.get(i), i);
            }
        }

        private void checkNullArgument(Tree syntaxTree, Symbol.MethodSymbol symbol, int param, SymbolicValue argumentValue, int index) {
            String nonNullAnnotation;
            ObjectConstraint constraint = this.programState.getConstraint(argumentValue, ObjectConstraint.class);
            if (constraint != null && constraint.isNull() && (nonNullAnnotation = NullableAnnotationUtils.nonNullAnnotation(JUtils.parameterAnnotations((Symbol.MethodSymbol)symbol, (int)param))) != null) {
                String message = "Parameter {0} to this {1} is marked \"{2}\" but null could be passed.";
                this.reportIssue(syntaxTree, message, index + 1, "<init>".equals(symbol.name()) ? "constructor" : "call", nonNullAnnotation);
            }
        }
    }

    private abstract class AbstractStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;

        protected AbstractStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        protected void reportIssue(Tree tree, String message, Object ... parameters) {
            this.context.reportIssue(tree, NonNullSetToNullCheck.this, MessageFormat.format(message, parameters));
        }
    }

    private class PostStatementVisitor
    extends AbstractStatementVisitor {
        protected PostStatementVisitor(CheckerContext context) {
            super(context);
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            Tree parent = tree.parent();
            while (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                if ((parent = parent.parent()) != null) continue;
                return;
            }
            String nonNullAnnotation = NullableAnnotationUtils.nonNullAnnotation((Symbol)((MethodTree)parent).symbol());
            if (nonNullAnnotation == null) {
                return;
            }
            if (this.isLocalExpression(tree.expression())) {
                this.checkReturnedValue(tree, nonNullAnnotation);
            }
        }

        private boolean isLocalExpression(@Nullable ExpressionTree expression) {
            if (expression == null) {
                return false;
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return JUtils.isLocalVariable((Symbol)((IdentifierTree)expression).symbol());
            }
            return true;
        }

        private void checkReturnedValue(ReturnStatementTree tree, String nonNullAnnotation) {
            SymbolicValue returnedValue = this.programState.peekValue();
            ObjectConstraint constraint = this.programState.getConstraint(returnedValue, ObjectConstraint.class);
            if (constraint != null && constraint.isNull()) {
                this.reportIssue((Tree)tree, "This method''s return value is marked \"{0}\" but null is returned.", nonNullAnnotation);
            }
        }
    }
}

