/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.StreamConsumedCheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;

@Rule(key="S3958")
public class StreamNotConsumedCheck
extends SECheck {
    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        if (context.getState().exitValue() instanceof SymbolicValue.ExceptionalSymbolicValue) {
            return;
        }
        ProgramState state = context.getState();
        List<SymbolicValue> notConsumed = state.getValuesWithConstraints(StreamConsumedCheck.StreamPipelineConstraint.NOT_CONSUMED);
        notConsumed.forEach(sv -> {
            Set<Flow> flows = FlowComputation.flow(context.getNode(), Collections.singleton(sv), StreamConsumedCheck.StreamPipelineConstraint.NOT_CONSUMED::equals, StreamConsumedCheck.StreamPipelineConstraint.NOT_CONSUMED::equals, Collections.singletonList(StreamConsumedCheck.StreamPipelineConstraint.class), Collections.emptySet(), 1);
            Flow flow = flows.iterator().next();
            List<JavaFileScannerContext.Location> elements = flow.elements();
            JavaFileScannerContext.Location location = elements.get(elements.size() - 1);
            this.reportIssue(location.syntaxNode, "Refactor the code so this stream pipeline is used.");
        });
    }
}

