/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S2095")
public class UnclosedResourcesCheck
extends SECheck {
    private static final List<Class<? extends Constraint>> RESOURCE_CONSTRAINT_DOMAIN = Collections.singletonList(ResourceConstraint.class);
    @RuleProperty(key="excludedResourceTypes", description="Comma separated list of the excluded resource types, using fully qualified names (example: \"org.apache.hadoop.fs.FileSystem\")", defaultValue="")
    public String excludedTypes = "";
    private final List<String> excludedTypesList = new ArrayList<String>();
    private final Set<TryStatementTree> visitedTryWithResourcesTrees = new HashSet<TryStatementTree>();
    private final Set<Tree> knownResources = new HashSet<Tree>();
    private Type visitedMethodOwnerType;
    private static final Pattern METHOD_NAMES_OPENING_RESOURCES = Pattern.compile("(new|create|open).*");
    private static final String JAVA_IO_AUTO_CLOSEABLE = "java.lang.AutoCloseable";
    private static final String JAVA_IO_CLOSEABLE = "java.io.Closeable";
    private static final String JAVA_SQL_CONNECTION = "java.sql.Connection";
    private static final String JAVA_NIO_FILE_FILES = "java.nio.file.Files";
    private static final MethodMatchers JDBC_RESOURCE_CREATIONS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.sql.Connection"}).names(new String[]{"createStatement", "prepareStatement", "prepareCall"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.sql.DataSource"}).names(new String[]{"getConnection"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.sql.DriverManager"}).names(new String[]{"getConnection"}).withAnyParameters().build()});
    private static final MethodMatchers STREAMS_BACKED_BY_RESOURCE = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Files"}).names(new String[]{"lines", "newDirectoryStream", "list", "find", "walk"}).withAnyParameters().build()});
    private static final MethodMatchers KNOWN_METHODS_KEEPING_ARGUMENTS_OPEN = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Properties"}).names(new String[]{"load", "store", "storeToXML", "save", "list"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.apache.commons.io.IOUtils"}).name((T name) -> name.startsWith("read") || name.startsWith("copy") || name.startsWith("contentEquals") || name.startsWith("skip") || "consume".equals(name)).withAnyParameters().build()});
    private static final String STREAM_TOP_HIERARCHY = "java.util.stream.BaseStream";
    private static final String[] IGNORED_CLOSEABLE_SUBTYPES = new String[]{"java.io.ByteArrayOutputStream", "java.io.ByteArrayInputStream", "java.io.CharArrayReader", "java.io.CharArrayWriter", "java.io.StringReader", "java.io.StringWriter", "org.apache.commons.io.output.ByteArrayOutputStream", "org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream", "com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream", "org.springframework.context.ConfigurableApplicationContext"};
    private static final MethodMatchers CLOSEABLE_EXCEPTIONS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.nio.file.FileSystems"}).names(new String[]{"getDefault"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{"javax.jms.Connection"}).names(new String[]{"createSession"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.jms.Session"}).names(new String[]{"createProducer", "createConsumer", "createDurableConsumer", "createSharedConsumer", "createSharedDurableConsumer"}).withAnyParameters().build()});

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.visitedTryWithResourcesTrees.clear();
        this.knownResources.clear();
        super.scanFile(context);
    }

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.visitedMethodOwnerType = methodTree.symbol().owner().type();
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        this.collectTryWithResources(syntaxNode);
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    private void collectTryWithResources(Tree syntaxNode) {
        TryStatementTree tryStatementTree;
        ListTree resourceList;
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) && !(resourceList = (tryStatementTree = (TryStatementTree)syntaxNode).resourceList()).isEmpty() && this.visitedTryWithResourcesTrees.add(tryStatementTree)) {
            this.knownResources.addAll(ResourcesCollector.collect((ListTree<Tree>)resourceList));
        }
    }

    private boolean isWithinTryHeader(Tree syntaxNode) {
        return this.knownResources.contains(syntaxNode);
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        if (context.getState().exitingOnRuntimeException()) {
            return;
        }
        ExplodedGraph.Node node = context.getNode();
        Set<SymbolicValue> svToReport = UnclosedResourcesCheck.symbolicValuesToReport(context);
        svToReport.forEach(sv -> this.processUnclosedSymbolicValue(node, (SymbolicValue)sv));
    }

    private static Set<SymbolicValue> symbolicValuesToReport(CheckerContext context) {
        List<SymbolicValue> openSymbolicValues = context.getState().getValuesWithConstraints(ResourceConstraint.OPEN);
        HashSet<SymbolicValue> svToReport = new HashSet<SymbolicValue>(openSymbolicValues);
        for (SymbolicValue openSymbolicValue : openSymbolicValues) {
            if (!(openSymbolicValue instanceof ResourceWrapperSymbolicValue)) continue;
            svToReport.remove(openSymbolicValue.wrappedValue());
        }
        return svToReport;
    }

    private void processUnclosedSymbolicValue(ExplodedGraph.Node node, SymbolicValue sv) {
        FlowComputation.flowWithoutExceptions(node, sv, ResourceConstraint.OPEN::equals, RESOURCE_CONSTRAINT_DOMAIN, 500000).stream().flatMap(Flow::firstFlowLocation).filter(location -> location.syntaxNode.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION})).forEach(this::reportIssue);
    }

    private void reportIssue(JavaFileScannerContext.Location location) {
        String message = "Use try-with-resources or close this \"" + UnclosedResourcesCheck.name(location.syntaxNode) + "\" in a \"finally\" clause.";
        this.reportIssue(location.syntaxNode, message);
    }

    private static String name(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return ((NewClassTree)tree).symbolType().name();
        }
        return ((MethodInvocationTree)tree).symbolType().name();
    }

    private static boolean needsClosing(Type type) {
        if (type.isSubtypeOf(STREAM_TOP_HIERARCHY)) {
            return false;
        }
        for (String ignoredType : IGNORED_CLOSEABLE_SUBTYPES) {
            if (!type.isSubtypeOf(ignoredType)) continue;
            return false;
        }
        return UnclosedResourcesCheck.isCloseable(type);
    }

    private boolean excludedByRuleOption(Type type) {
        return this.loadExcludedTypesList().stream().anyMatch(arg_0 -> ((Type)type).is(arg_0));
    }

    private List<String> loadExcludedTypesList() {
        if (this.excludedTypesList.isEmpty() && !StringUtils.isBlank((CharSequence)this.excludedTypes)) {
            for (String excludedType : this.excludedTypes.split(",")) {
                this.excludedTypesList.add(excludedType.trim());
            }
        }
        return this.excludedTypesList;
    }

    private static boolean isCloseable(ExpressionTree expr) {
        return UnclosedResourcesCheck.isCloseable(expr.symbolType());
    }

    private static boolean isCloseable(Type type) {
        return type.isSubtypeOf(JAVA_IO_AUTO_CLOSEABLE) || type.isSubtypeOf(JAVA_IO_CLOSEABLE);
    }

    private boolean isOpeningResource(NewClassTree syntaxNode) {
        if (this.isWithinTryHeader((Tree)syntaxNode) || this.excludedByRuleOption(syntaxNode.symbolType())) {
            return false;
        }
        return UnclosedResourcesCheck.needsClosing(syntaxNode.symbolType());
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String CLOSE = "close";
        private final ConstraintManager constraintManager;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
        }

        public void visitNewClass(NewClassTree syntaxNode) {
            if (UnclosedResourcesCheck.this.isOpeningResource(syntaxNode)) {
                List arguments = ListUtils.reverse(this.programState.peekValuesAndSymbols(syntaxNode.arguments().size()));
                Iterator iterator = arguments.iterator();
                for (ExpressionTree argumentTree : syntaxNode.arguments()) {
                    if (!iterator.hasNext()) {
                        throw new IllegalStateException("Mismatch between declared constructor arguments and argument values!");
                    }
                    ProgramState.SymbolicValueSymbol argument = (ProgramState.SymbolicValueSymbol)iterator.next();
                    if (this.shouldWrapArgument(argument, argumentTree)) {
                        this.constraintManager.setValueFactory(new WrappedValueFactory(argument.symbolicValue()));
                        break;
                    }
                    if (!this.shouldCloseArgument(argument)) continue;
                    this.closeResource(argument.symbolicValue());
                }
            } else {
                this.closeArguments(syntaxNode.arguments());
            }
        }

        private boolean shouldWrapArgument(ProgramState.SymbolicValueSymbol argument, ExpressionTree argumentTree) {
            ResourceConstraint argConstraint = this.programState.getConstraint(argument.symbolicValue(), ResourceConstraint.class);
            return argConstraint == ResourceConstraint.OPEN && argument.symbol() != null || argConstraint == null && UnclosedResourcesCheck.isCloseable(argumentTree);
        }

        private boolean shouldCloseArgument(ProgramState.SymbolicValueSymbol argument) {
            ResourceConstraint argConstraint = this.programState.getConstraint(argument.symbolicValue(), ResourceConstraint.class);
            return argConstraint == ResourceConstraint.OPEN;
        }

        public void visitReturnStatement(ReturnStatementTree syntaxNode) {
            ExpressionTree expression;
            SymbolicValue currentVal = this.programState.peekValue();
            if (currentVal != null && (expression = syntaxNode.expression()) != null) {
                if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    IdentifierTree identifier = (IdentifierTree)expression;
                    currentVal = this.programState.getValue(identifier.symbol());
                } else {
                    currentVal = this.programState.peekValue();
                }
                this.closeResource(currentVal);
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree syntaxNode) {
            ExpressionTree variable = syntaxNode.variable();
            if (this.isNonLocalStorage(variable)) {
                SymbolicValue value = ExpressionUtils.isSimpleAssignment((AssignmentExpressionTree)syntaxNode) ? this.programState.peekValue() : this.programState.peekValues(2).get(0);
                this.closeResource(value);
            }
        }

        private boolean isNonLocalStorage(ExpressionTree variable) {
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol owner = ((IdentifierTree)variable).symbol().owner();
                return !owner.isMethodSymbol();
            }
            return true;
        }

        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            Symbol.MethodSymbol symbol = syntaxNode.methodSymbol();
            if (symbol.isMethodSymbol() && syntaxNode.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                String methodName = symbol.name();
                SymbolicValue value = this.getTargetValue(syntaxNode);
                if (value != null && CLOSE.equals(methodName)) {
                    this.closeResource(value);
                }
            }
            if (!KNOWN_METHODS_KEEPING_ARGUMENTS_OPEN.matches(syntaxNode)) {
                this.closeArguments(syntaxNode.arguments());
            }
        }

        @CheckForNull
        private SymbolicValue getTargetValue(MethodInvocationTree syntaxNode) {
            SymbolicValue value;
            ExpressionTree targetExpression = ((MemberSelectExpressionTree)syntaxNode.methodSelect()).expression();
            if (targetExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifier = (IdentifierTree)targetExpression;
                value = this.programState.getValue(identifier.symbol());
            } else {
                value = this.programState.peekValue();
            }
            return value;
        }

        private void closeArguments(Arguments arguments) {
            this.programState.peekValues(arguments.size()).forEach(this::closeResource);
        }

        private void closeResource(@Nullable SymbolicValue target) {
            ResourceConstraint oConstraint;
            if (target instanceof ResourceWrapperSymbolicValue) {
                this.closeResource(target.wrappedValue());
            }
            if (target != null && (oConstraint = this.programState.getConstraint(target, ResourceConstraint.class)) != null) {
                this.programState = this.programState.addConstraintTransitively(target, ResourceConstraint.CLOSED);
            }
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (UnclosedResourcesCheck.this.isWithinTryHeader((Tree)tree)) {
                Symbol symbol = tree.symbol();
                this.closeResource(this.programState.getValue(symbol));
            }
        }
    }

    private static class ResourcesCollector
    extends BaseTreeVisitor {
        private final Set<Tree> resources = new HashSet<Tree>();

        private ResourcesCollector() {
        }

        static Set<Tree> collect(ListTree<Tree> resources) {
            ResourcesCollector collector = new ResourcesCollector();
            resources.accept((TreeVisitor)collector);
            return collector.resources;
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.resources.add((Tree)tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.resources.add((Tree)tree);
            super.visitMethodInvocation(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            this.resources.add((Tree)tree);
            super.visitNewClass(tree);
        }
    }

    private class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        public void visitNewClass(NewClassTree syntaxNode) {
            SymbolicValue instanceValue = Objects.requireNonNull(this.programState.peekValue());
            if (UnclosedResourcesCheck.this.isOpeningResource(syntaxNode) && !this.passedCloseableParameter(instanceValue)) {
                this.programState = this.programState.addConstraintTransitively(instanceValue, ResourceConstraint.OPEN);
            }
        }

        private boolean passedCloseableParameter(SymbolicValue resource) {
            return resource instanceof ResourceWrapperSymbolicValue && this.programState.getConstraint(((ResourceWrapperSymbolicValue)resource).dependent, ResourceConstraint.class) == null;
        }

        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            if (this.methodOpeningResource(syntaxNode)) {
                SymbolicValue peekedValue = Objects.requireNonNull(this.programState.peekValue());
                this.programState = this.programState.addConstraintTransitively(peekedValue, ResourceConstraint.OPEN);
                this.programState = this.programState.addConstraint(peekedValue, ObjectConstraint.NOT_NULL);
            }
        }

        private boolean methodOpeningResource(MethodInvocationTree mit) {
            return !UnclosedResourcesCheck.this.isWithinTryHeader((Tree)mit) && !UnclosedResourcesCheck.this.excludedByRuleOption(mit.symbolType()) && !this.handledByFramework(mit) && (JDBC_RESOURCE_CREATIONS.matches(mit) || STREAMS_BACKED_BY_RESOURCE.matches(mit) || UnclosedResourcesCheck.needsClosing(mit.symbolType()) && !CLOSEABLE_EXCEPTIONS.matches(mit) && this.mitHeuristics(mit));
        }

        private boolean handledByFramework(MethodInvocationTree mit) {
            return JDBC_RESOURCE_CREATIONS.matches(mit) && (UnclosedResourcesCheck.this.visitedMethodOwnerType.isSubtypeOf("org.springframework.jdbc.core.PreparedStatementCreator") || UnclosedResourcesCheck.this.visitedMethodOwnerType.isSubtypeOf("org.springframework.jdbc.core.CallableStatementCreator"));
        }

        private boolean mitHeuristics(MethodInvocationTree mit) {
            Symbol.MethodSymbol methodSymbol = mit.methodSymbol();
            return !methodSymbol.isUnknown() && this.invocationOfMethodFromOtherClass((Symbol)methodSymbol) && METHOD_NAMES_OPENING_RESOURCES.matcher(methodSymbol.name()).matches();
        }

        private boolean invocationOfMethodFromOtherClass(Symbol methodSymbol) {
            return !UnclosedResourcesCheck.this.visitedMethodOwnerType.symbol().equals((Object)methodSymbol.owner());
        }
    }

    public static enum ResourceConstraint implements Constraint
    {
        OPEN,
        CLOSED;


        @Override
        public String valueAsString() {
            if (this == OPEN) {
                return "open";
            }
            return "closed";
        }
    }

    private static class ResourceWrapperSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue dependent;

        ResourceWrapperSymbolicValue(SymbolicValue dependent) {
            this.dependent = dependent;
        }

        @Override
        public SymbolicValue wrappedValue() {
            return this.dependent;
        }
    }

    private static class WrappedValueFactory
    implements SymbolicValueFactory {
        private final SymbolicValue value;

        WrappedValueFactory(SymbolicValue value) {
            this.value = value;
        }

        @Override
        public SymbolicValue createSymbolicValue() {
            return new ResourceWrapperSymbolicValue(this.value);
        }
    }
}

