/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.se.AlwaysTrueOrFalseExpressionCollector;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2589")
public class BooleanGratuitousExpressionsCheck
extends SECheck {
    @Override
    public void checkEndOfExecution(CheckerContext context) {
        AlwaysTrueOrFalseExpressionCollector atof = context.alwaysTrueOrFalseExpressions();
        for (Tree condition : atof.alwaysFalse()) {
            this.reportBooleanExpression(context, atof, condition, false);
        }
        for (Tree condition : atof.alwaysTrue()) {
            this.reportBooleanExpression(context, atof, condition, true);
        }
    }

    private void reportBooleanExpression(CheckerContext context, AlwaysTrueOrFalseExpressionCollector atof, Tree condition, boolean isTrue) {
        if (!AlwaysTrueOrFalseExpressionCollector.hasUnreachableCode(condition, isTrue)) {
            Set<Flow> flows = atof.flowForExpression(condition, 20).stream().map(flow -> AlwaysTrueOrFalseExpressionCollector.addIssueLocation(flow, condition, isTrue)).collect(Collectors.toSet());
            context.reportIssue(condition, this, "Remove this expression which always evaluates to \"" + isTrue + "\"", flows);
        }
    }
}

