/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;

public enum BooleanConstraint implements Constraint
{
    TRUE,
    FALSE;


    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean hasPreciseValue() {
        return true;
    }

    @Override
    public String valueAsString() {
        if (this == TRUE) {
            return "true";
        }
        return "false";
    }

    @Override
    @Nullable
    public Constraint copyOver(RelationalSymbolicValue.Kind kind) {
        switch (kind) {
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return null;
            }
            case EQUAL: 
            case METHOD_EQUALS: {
                return this;
            }
        }
        return this.inverse();
    }

    @Override
    public boolean isValidWith(@Nullable Constraint constraint) {
        return constraint == null || this == constraint;
    }

    @Override
    public BooleanConstraint inverse() {
        if (TRUE == this) {
            return FALSE;
        }
        return TRUE;
    }
}

