/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import java.util.EnumMap;
import java.util.Map;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;

class RelationStateTable {
    private static final Map<RelationalSymbolicValue.Kind, Map<RelationalSymbolicValue.Kind, RelationState>> table = new EnumMap<RelationalSymbolicValue.Kind, Map<RelationalSymbolicValue.Kind, RelationState>>(RelationalSymbolicValue.Kind.class);

    private RelationStateTable() {
    }

    private static void set(RelationalSymbolicValue.Kind op1, RelationalSymbolicValue.Kind op2, RelationState state) {
        Map op1Map = table.computeIfAbsent(op1, kind -> new EnumMap(RelationalSymbolicValue.Kind.class));
        RelationState relationState = (RelationState)((Object)op1Map.get((Object)op2));
        if (relationState != null) {
            throw new IllegalStateException("Value already present!");
        }
        op1Map.put(op2, state);
    }

    private static RelationState get(RelationalSymbolicValue.Kind given, RelationalSymbolicValue.Kind when) {
        Map<RelationalSymbolicValue.Kind, RelationState> givenMap = table.get((Object)given);
        if (givenMap == null) {
            return RelationState.UNDETERMINED;
        }
        return givenMap.getOrDefault((Object)when, RelationState.UNDETERMINED);
    }

    static RelationState solveRelation(RelationalSymbolicValue.Kind known, RelationalSymbolicValue.Kind toSolve) {
        RelationState relationState = RelationStateTable.get(known, toSolve);
        if (relationState.isDetermined()) {
            return relationState;
        }
        return RelationStateTable.get(known, toSolve.inverse()).invert();
    }

    static {
        RelationStateTable.set(RelationalSymbolicValue.Kind.EQUAL, RelationalSymbolicValue.Kind.LESS_THAN, RelationState.UNFULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.EQUAL, RelationalSymbolicValue.Kind.METHOD_EQUALS, RelationState.FULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.LESS_THAN, RelationalSymbolicValue.Kind.EQUAL, RelationState.UNFULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.LESS_THAN, RelationalSymbolicValue.Kind.LESS_THAN, RelationState.UNFULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.LESS_THAN, RelationalSymbolicValue.Kind.METHOD_EQUALS, RelationState.UNFULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.METHOD_EQUALS, RelationalSymbolicValue.Kind.LESS_THAN, RelationState.UNFULFILLED);
        RelationStateTable.set(RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS, RelationalSymbolicValue.Kind.EQUAL, RelationState.UNFULFILLED);
    }
}

