/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.Preconditions;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3655")
public class OptionalGetBeforeIsPresentCheck
extends SECheck {
    private static final MethodMatchers.NameBuilder JAVA_UTIL_OPTIONAL = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"});
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("\"NoSuchElementException\" will be thrown when invoking method \"%s()\" without verifying Optional parameter.");
    private static final MethodMatchers OPTIONAL_GET = JAVA_UTIL_OPTIONAL.names(new String[]{"get"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers OPTIONAL_ORELSE = JAVA_UTIL_OPTIONAL.names(new String[]{"orElse"}).withAnyParameters().build();
    private static final MethodMatchers OPTIONAL_TEST_METHODS = JAVA_UTIL_OPTIONAL.names(new String[]{"isPresent", "isEmpty"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers OPTIONAL_EMPTY = JAVA_UTIL_OPTIONAL.names(new String[]{"empty"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers OPTIONAL_OF = JAVA_UTIL_OPTIONAL.names(new String[]{"of"}).withAnyParameters().build();
    private static final MethodMatchers OPTIONAL_OF_NULLABLE = JAVA_UTIL_OPTIONAL.names(new String[]{"ofNullable"}).withAnyParameters().build();
    private static final MethodMatchers OPTIONAL_FILTER = JAVA_UTIL_OPTIONAL.names(new String[]{"filter"}).withAnyParameters().build();

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(this, context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        List<ProgramState> programStates = OptionalGetBeforeIsPresentCheck.setOptionalConstraint(context, syntaxNode);
        Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
        return programStates.get(0);
    }

    private static List<ProgramState> setOptionalConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue paramSV;
        ProgramState psPriorMethodInvocation;
        ObjectConstraint paramConstraint;
        ProgramState programState = context.getState();
        if (!syntaxNode.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return Collections.singletonList(programState);
        }
        MethodInvocationTree mit = (MethodInvocationTree)syntaxNode;
        SymbolicValue peekValue = programState.peekValue();
        Objects.requireNonNull(peekValue);
        if (OPTIONAL_EMPTY.matches(mit)) {
            return peekValue.setConstraint(programState, OptionalConstraint.NOT_PRESENT);
        }
        if (OPTIONAL_OF.matches(mit)) {
            return peekValue.setConstraint(programState, OptionalConstraint.PRESENT);
        }
        if (OPTIONAL_OF_NULLABLE.matches(mit) && (paramConstraint = (psPriorMethodInvocation = context.getNode().programState).getConstraint(paramSV = psPriorMethodInvocation.peekValue(0), ObjectConstraint.class)) != null) {
            return peekValue.setConstraint(programState, paramConstraint == ObjectConstraint.NULL ? OptionalConstraint.NOT_PRESENT : OptionalConstraint.PRESENT);
        }
        return Collections.singletonList(programState);
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;
        private final ConstraintManager constraintManager;
        private final SECheck check;
        private final boolean java11;

        private PreStatementVisitor(SECheck check, CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
            this.check = check;
            this.java11 = context.getScannerContext().getJavaVersion().asInt() >= 11;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (PreStatementVisitor.isInvocationOnClassInstanceField(tree)) {
                return;
            }
            if (OPTIONAL_GET.matches(tree)) {
                this.handleOptionalGetMethod(tree);
            } else if (OPTIONAL_TEST_METHODS.matches(tree)) {
                this.handleOptionalTestMethods(tree);
            } else if (OPTIONAL_FILTER.matches(tree)) {
                this.handleOptionalFilterMethod();
            } else if (OPTIONAL_ORELSE.matches(tree)) {
                this.handleOptionalOrElseMethod(tree);
            } else if (OPTIONAL_OF.matches(tree)) {
                this.handleOptionalOfMethod();
            } else if (OPTIONAL_OF_NULLABLE.matches(tree)) {
                this.handleOptionalOfNullableMethod();
            }
        }

        private void handleOptionalOfMethod() {
            this.constraintManager.setValueFactory(() -> new OptionalSymbolicValue(this.programState.peekValue()));
        }

        private void handleOptionalTestMethods(MethodInvocationTree tree) {
            this.constraintManager.setValueFactory(() -> new OptionalTestMethodSymbolicValue(this.programState.peekValue(), (Symbol)tree.methodSymbol()));
        }

        private void handleOptionalGetMethod(MethodInvocationTree tree) {
            if (this.presenceHasNotBeenChecked(this.programState.peekValueSymbol())) {
                SymbolicValue optionalSV = Objects.requireNonNull(this.programState.peekValue());
                this.context.addExceptionalYield(optionalSV, this.programState, "java.util.NoSuchElementException", this.check);
                this.reportIssue(tree);
                this.programState = this.programState.addConstraint(optionalSV, OptionalConstraint.PRESENT);
            }
        }

        private void handleOptionalFilterMethod() {
            SymbolicValue optionalSV = this.programState.peekValue(1);
            if (this.programState.getConstraint(optionalSV, OptionalConstraint.class) == OptionalConstraint.NOT_PRESENT) {
                this.constraintManager.setValueFactory(() -> optionalSV);
            } else {
                this.constraintManager.setValueFactory(() -> new FilteredOptionalSymbolicValue(optionalSV));
            }
        }

        private void handleOptionalOrElseMethod(MethodInvocationTree tree) {
            SymbolicValue symbolicValue;
            ProgramState.Pop pop = this.programState.unstackValue(2);
            SymbolicValue orElseValue = pop.values.get(0);
            SymbolicValue optional = pop.values.get(1);
            List<ProgramState> psEmpty = optional.setConstraint(pop.state.stackValue(orElseValue), OptionalConstraint.NOT_PRESENT);
            if (optional instanceof OptionalSymbolicValue) {
                OptionalSymbolicValue optionalSymbolicValue = (OptionalSymbolicValue)optional;
                symbolicValue = optionalSymbolicValue.wrappedValue;
            } else {
                symbolicValue = this.constraintManager.createSymbolicValue((Tree)tree);
            }
            List<ProgramState> psPresent = optional.setConstraint(pop.state.stackValue(symbolicValue), OptionalConstraint.PRESENT);
            psEmpty.forEach(this.context::addTransition);
            psPresent.forEach(this.context::addTransition);
            this.programState = null;
        }

        private void handleOptionalOfNullableMethod() {
            SymbolicValue ofNullableParameter = Objects.requireNonNull(this.programState.peekValue());
            ObjectConstraint nullability = this.programState.getConstraint(ofNullableParameter, ObjectConstraint.class);
            if (nullability != null) {
                this.constraintManager.setValueFactory(() -> new OptionalSymbolicValue(ofNullableParameter));
            } else {
                OptionalSymbolicValue optionalSV = new OptionalSymbolicValue(ofNullableParameter);
                ProgramState newState = this.programState.unstackValue((int)2).state.stackValue(optionalSV);
                ofNullableParameter.setConstraint(newState, ObjectConstraint.NULL).stream().map(ps -> optionalSV.setConstraint((ProgramState)ps, OptionalConstraint.NOT_PRESENT)).flatMap(Collection::stream).forEach(this.context::addTransition);
                ofNullableParameter.setConstraint(newState, ObjectConstraint.NOT_NULL).stream().map(ps -> optionalSV.setConstraint((ProgramState)ps, OptionalConstraint.PRESENT)).flatMap(Collection::stream).forEach(this.context::addTransition);
                this.programState = null;
            }
        }

        private void reportIssue(MethodInvocationTree mit) {
            MethodInvocationTree reportTree = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)mit.methodSelect()).expression() : mit;
            String owner = PreStatementVisitor.getIdentifierPart(mit.methodSelect()).map(name -> name + ".").orElse("Optional#");
            String alternative = this.java11 ? String.format(" or \"!%sisEmpty()\"", owner) : "";
            this.context.reportIssue((Tree)reportTree, this.check, String.format("Call \"%sisPresent()\"%s before accessing the value.", owner, alternative));
        }

        private boolean presenceHasNotBeenChecked(ProgramState.SymbolicValueSymbol symbolicValueSymbol) {
            OptionalConstraint optionalConstraint = this.programState.getConstraint(symbolicValueSymbol.symbolicValue(), OptionalConstraint.class);
            Symbol symbol = symbolicValueSymbol.symbol();
            if (symbol != null && ProgramState.isField(symbol)) {
                return optionalConstraint == OptionalConstraint.NOT_PRESENT;
            }
            return optionalConstraint != OptionalConstraint.PRESENT;
        }

        private static Optional<String> getIdentifierPart(ExpressionTree methodSelect) {
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return Optional.of(((IdentifierTree)expression).name());
                }
            }
            return Optional.empty();
        }

        private static boolean isInvocationOnClassInstanceField(MethodInvocationTree mit) {
            ExpressionTree mitExpression = mit.methodSelect();
            if (mitExpression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = ((MemberSelectExpressionTree)mitExpression).expression();
                if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    IdentifierTree identifier = ((MemberSelectExpressionTree)expression).identifier();
                    return ProgramState.isField(identifier.symbol());
                }
            }
            return false;
        }
    }

    private static enum OptionalConstraint implements Constraint
    {
        PRESENT,
        NOT_PRESENT;


        @Override
        public boolean isValidWith(@Nullable Constraint constraint) {
            return constraint == null || this == constraint;
        }

        @Override
        public boolean hasPreciseValue() {
            return this == NOT_PRESENT;
        }
    }

    private static class OptionalTestMethodSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue optionalSV;
        private final boolean isIsEmpty;

        public OptionalTestMethodSymbolicValue(SymbolicValue sv, Symbol testMethod) {
            this.optionalSV = sv;
            this.isIsEmpty = "isEmpty".equals(testMethod.name());
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            OptionalConstraint optionalConstraint = programState.getConstraint(this.optionalSV, OptionalConstraint.class);
            if (this.isImpossibleState(booleanConstraint, optionalConstraint)) {
                return Collections.emptyList();
            }
            if (optionalConstraint == OptionalConstraint.NOT_PRESENT || optionalConstraint == OptionalConstraint.PRESENT) {
                return Collections.singletonList(programState);
            }
            return this.optionalSV.setConstraint(programState, this.expectedOptionalConstraint(booleanConstraint));
        }

        private boolean isImpossibleState(BooleanConstraint booleanConstraint, @Nullable OptionalConstraint optionalConstraint) {
            return optionalConstraint == this.expectedOptionalConstraint(booleanConstraint.isTrue() ? BooleanConstraint.FALSE : BooleanConstraint.TRUE);
        }

        private OptionalConstraint expectedOptionalConstraint(BooleanConstraint booleanConstraint) {
            if (booleanConstraint.isTrue()) {
                return this.isIsEmpty ? OptionalConstraint.NOT_PRESENT : OptionalConstraint.PRESENT;
            }
            return this.isIsEmpty ? OptionalConstraint.PRESENT : OptionalConstraint.NOT_PRESENT;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.optionalSV.equals(other) || this.optionalSV.references(other);
        }
    }

    private static class FilteredOptionalSymbolicValue
    extends OptionalSymbolicValue {
        private FilteredOptionalSymbolicValue(SymbolicValue wrappedValue) {
            super(wrappedValue);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
            ProgramState ps = programState;
            if (constraint == OptionalConstraint.PRESENT) {
                List<ProgramState> programStates = this.wrappedValue.setConstraint(ps, constraint);
                Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
                ps = programStates.get(0);
            }
            return super.setConstraint(ps, constraint);
        }
    }

    private static class OptionalSymbolicValue
    extends SymbolicValue {
        protected final SymbolicValue wrappedValue;

        private OptionalSymbolicValue(SymbolicValue wrappedValue) {
            this.wrappedValue = wrappedValue;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.wrappedValue.equals(other) || this.wrappedValue.references(other);
        }
    }
}

