/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S6377")
public class XmlValidatedSignatureCheck
extends SECheck {
    private static final String MESSAGE = "Set the 'org.jcp.xml.dsig.secureValidation' property to \"true\" on the 'DOMValidateContext' object to validate this XML signature securely.";
    private static final String JAVAX_XML_CRYPTO_VALIDATE_CONTEXT = "javax.xml.crypto.dsig.XMLValidateContext";
    private static final MethodMatchers DOM_VALIDATE_CONTEXT_CONSTRUCTOR = MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.crypto.dsig.XMLValidateContext"}).constructor().withAnyParameters().build();
    private static final MethodMatchers SET_PROPERTY = MethodMatchers.create().ofSubTypes(new String[]{"javax.xml.crypto.dsig.XMLValidateContext"}).names(new String[]{"setProperty"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Object"}).build();
    private static final MethodMatchers XML_SIGNATURE_VALIDATE = MethodMatchers.create().ofAnyType().names(new String[]{"validate"}).addParametersMatcher(new String[]{"javax.xml.crypto.dsig.XMLValidateContext"}).build();
    private static final List<Class<? extends Constraint>> DOMAINS = Collections.singletonList(DomSecureValidation.class);

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept((TreeVisitor)visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ProgramState endState = context.getState();
        if (endState.exitingOnRuntimeException()) {
            return;
        }
        this.reportIfNotSecured(context, endState, endState.peekValue());
    }

    private void reportIfNotSecured(CheckerContext context, ProgramState ps, @Nullable SymbolicValue sv) {
        if (!(sv instanceof DomValidateContextSymbolicValue)) {
            return;
        }
        DomValidateContextSymbolicValue domSv = (DomValidateContextSymbolicValue)sv;
        if (domSv.isField) {
            return;
        }
        Optional.ofNullable(ps.getConstraint(domSv, DomSecureValidation.class)).ifPresent(constraint -> this.report(context, domSv, (DomSecureValidation)constraint));
    }

    private void report(CheckerContext context, DomValidateContextSymbolicValue sv, DomSecureValidation constraint) {
        Tree reportTree = sv.init;
        String message = MESSAGE;
        if (constraint != DomSecureValidation.DISABLED) {
            reportTree = FlowComputation.flowWithoutExceptions(context.getNode(), sv, DomSecureValidation.IS_EXPLICITLY_DISABLED, DOMAINS, 1).stream().findFirst().flatMap(f -> f.elements().stream().findFirst()).map(e -> e.syntaxNode).orElse(sv.init);
        }
        if (reportTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            reportTree = (Tree)((MethodInvocationTree)reportTree).arguments().get(1);
            message = "Change this to \"true\" to validate this XML signature securely.";
        }
        context.reportIssue(reportTree, this, message);
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        private PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        public void visitNewClass(NewClassTree tree) {
            if (DOM_VALIDATE_CONTEXT_CONSTRUCTOR.matches(tree)) {
                this.programState = this.programState.addConstraint(this.programState.peekValue(0), DomSecureValidation.DISABLED);
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ProgramState.SymbolicValueSymbol peek = this.programState.peekValueSymbol();
            Symbol symbol = peek.symbol();
            SymbolicValue sv = peek.symbolicValue();
            if (symbol != null && sv instanceof DomValidateContextSymbolicValue) {
                DomValidateContextSymbolicValue domValidateContextSymbolicValue = (DomValidateContextSymbolicValue)sv;
                domValidateContextSymbolicValue.setField(ProgramState.isField(symbol));
            }
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String SECURE_VALIDATION_PROPERTY = "org.jcp.xml.dsig.secureValidation";
        private final CheckerContext context;

        private PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        public void visitNewClass(NewClassTree newClass) {
            if (DOM_VALIDATE_CONTEXT_CONSTRUCTOR.matches(newClass)) {
                this.context.getConstraintManager().setValueFactory(() -> new DomValidateContextSymbolicValue((Tree)newClass.identifier()));
            }
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (SET_PROPERTY.matches(mit)) {
                Arguments args = mit.arguments();
                if (((ExpressionTree)args.get(0)).asConstant(String.class).filter(SECURE_VALIDATION_PROPERTY::equalsIgnoreCase).isEmpty()) {
                    return;
                }
                SymbolicValue domSv = this.programState.peekValue(args.size());
                this.programState = this.programState.getConstraint(this.programState.peekValue(0), BooleanConstraint.class) == BooleanConstraint.FALSE ? this.programState.addConstraint(domSv, DomSecureValidation.EXPLICITLY_DISABLED) : this.programState.removeConstraintsOnDomain(domSv, DomSecureValidation.class);
            } else if (XML_SIGNATURE_VALIDATE.matches(mit)) {
                XmlValidatedSignatureCheck.this.reportIfNotSecured(this.context, this.programState, this.programState.peekValue(0));
            }
        }
    }

    @VisibleForTesting
    static class DomValidateContextSymbolicValue
    extends SymbolicValue {
        private final Tree init;
        private boolean isField;

        DomValidateContextSymbolicValue(Tree init) {
            this.init = init;
            this.isField = false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomValidateContextSymbolicValue that = (DomValidateContextSymbolicValue)o;
            return this.isField == that.isField && this.init.equals((Object)that.init);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.init, this.isField);
        }

        public void setField(boolean isField) {
            this.isField = isField;
        }
    }

    private static enum DomSecureValidation implements Constraint
    {
        DISABLED,
        EXPLICITLY_DISABLED;

        private static final Predicate<Constraint> IS_EXPLICITLY_DISABLED;

        static {
            IS_EXPLICITLY_DISABLED = c -> c == EXPLICITLY_DISABLED;
        }
    }
}

