/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.Preconditions;
import org.sonar.java.model.Symbols;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.constraint.TypedConstraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class SymbolicValue {
    public static final SymbolicValue NULL_LITERAL = new SymbolicValue(){

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            return Collections.emptyList();
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
            if (constraint instanceof ObjectConstraint) {
                ObjectConstraint objectConstraint = (ObjectConstraint)constraint;
                return super.setConstraint(programState, objectConstraint);
            }
            return Collections.singletonList(programState);
        }

        @Override
        public String toString() {
            return "SV_NULL";
        }
    };
    public static final SymbolicValue TRUE_LITERAL = new SymbolicValue(){

        @Override
        public String toString() {
            return "SV_TRUE";
        }
    };
    public static final SymbolicValue FALSE_LITERAL = new SymbolicValue(){

        @Override
        public String toString() {
            return "SV_FALSE";
        }
    };
    private static final List<SymbolicValue> PROTECTED_SYMBOLIC_VALUES = Arrays.asList(NULL_LITERAL, TRUE_LITERAL, FALSE_LITERAL);
    private static int idGenerator;
    private final int id = idGenerator++;

    public int hashCode() {
        return 31 * this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicValue that = (SymbolicValue)o;
        Preconditions.checkState((this.id != that.id ? 1 : 0) != 0, (String)"Impossible to have two SV with same id");
        return false;
    }

    public static boolean isDisposable(SymbolicValue symbolicValue) {
        if (symbolicValue instanceof NotSymbolicValue) {
            NotSymbolicValue notSV = (NotSymbolicValue)symbolicValue;
            return !(notSV.operand instanceof RelationalSymbolicValue);
        }
        return !PROTECTED_SYMBOLIC_VALUES.contains(symbolicValue) && !(symbolicValue instanceof RelationalSymbolicValue);
    }

    public boolean references(SymbolicValue other) {
        return false;
    }

    public String toString() {
        return "SV_" + this.id;
    }

    public void computedFrom(List<ProgramState.SymbolicValueSymbol> symbolicValues) {
    }

    public List<Symbol> computedFromSymbols() {
        return Collections.emptyList();
    }

    public List<SymbolicValue> computedFrom() {
        return Collections.emptyList();
    }

    public List<ProgramState> setConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        Object constraint = programState.getConstraint(this, nullConstraint.getClass());
        if (constraint == null) {
            if (nullConstraint.isNull()) {
                ConstraintsByDomain onlyNullConstraint = ConstraintsByDomain.empty().put(ObjectConstraint.NULL);
                return Collections.singletonList(programState.addConstraints(this, onlyNullConstraint));
            }
            return Collections.singletonList(programState.addConstraint(this, nullConstraint));
        }
        if (constraint != nullConstraint) {
            return Collections.emptyList();
        }
        return Collections.singletonList(programState);
    }

    public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
        Object cstraint = programState.getConstraint(this, booleanConstraint.getClass());
        if (!booleanConstraint.isValidWith((Constraint)cstraint)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(programState.addConstraint(this, booleanConstraint));
    }

    public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
        if (constraint instanceof BooleanConstraint) {
            BooleanConstraint booleanConstraint = (BooleanConstraint)constraint;
            return this.setConstraint(programState, booleanConstraint);
        }
        if (constraint instanceof ObjectConstraint) {
            ObjectConstraint objectConstraint = (ObjectConstraint)constraint;
            return this.setConstraint(programState, objectConstraint);
        }
        Object csrtaint = programState.getConstraint(this, constraint.getClass());
        if (constraint.isValidWith((Constraint)csrtaint)) {
            return Collections.singletonList(programState.addConstraint(this, constraint));
        }
        return Collections.emptyList();
    }

    public ProgramState setSingleConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        List<ProgramState> states = this.setConstraint(programState, nullConstraint);
        if (states.size() != 1) {
            throw new IllegalStateException("Only a single program state is expected at this location");
        }
        return states.get(0);
    }

    protected List<ProgramState> setConstraint(ProgramState state, Constraint constraint, Set<RelationalSymbolicValue> knownRelations) {
        return this.setConstraint(state, constraint);
    }

    public SymbolicValue wrappedValue() {
        return this;
    }

    public static class NotSymbolicValue
    extends UnarySymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            return this.operand.setConstraint(programState, booleanConstraint.inverse());
        }

        @Override
        public String toString() {
            return "!(" + String.valueOf(this.operand) + ")";
        }
    }

    public static final class BooleanSymbolicValue
    extends SymbolicValue {
    }

    public static class XorSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint.inverse()));
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return String.valueOf(this.leftOp) + " ^ " + String.valueOf(this.rightOp);
        }
    }

    public static class OrSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isTrue()) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
                for (ProgramState ps : trueFirstOp) {
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return String.valueOf(this.leftOp) + " | " + String.valueOf(this.rightOp);
        }
    }

    public static class AndSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isFalse()) {
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
                for (ProgramState ps : falseFirstOp) {
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return String.valueOf(this.leftOp) + " & " + String.valueOf(this.rightOp);
        }
    }

    public static abstract class BooleanExpressionSymbolicValue
    extends BinarySymbolicValue {
        protected static void addStates(List<ProgramState> states, List<ProgramState> newStates) {
            if (states.size() > 10000 || newStates.size() > 10000) {
                throw new ExplodedGraphWalker.TooManyNestedBooleanStatesException();
            }
            states.addAll(newStates);
        }
    }

    public static class InstanceOfSymbolicValue
    extends UnarySymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            if (booleanConstraint.isTrue()) {
                ObjectConstraint constraint = programState.getConstraint(this.operand, ObjectConstraint.class);
                if (constraint != null && constraint.isNull()) {
                    return Collections.emptyList();
                }
                List<ProgramState> ps = this.operand.setConstraint(programState, ObjectConstraint.NOT_NULL);
                if (ps.size() == 1 && ps.get(0).equals(programState)) {
                    return Collections.singletonList(programState.addConstraint(this, new TypedConstraint(Symbols.unknownType.fullyQualifiedName())));
                }
                return ps;
            }
            return Collections.singletonList(programState);
        }
    }

    public static class CaughtExceptionSymbolicValue
    extends SymbolicValue {
        private final ExceptionalSymbolicValue thrownSV;

        public CaughtExceptionSymbolicValue(ExceptionalSymbolicValue thrownSV) {
            this.thrownSV = thrownSV;
        }

        public ExceptionalSymbolicValue exception() {
            return this.thrownSV;
        }
    }

    public static class ExceptionalSymbolicValue
    extends SymbolicValue {
        @Nullable
        private final Type exceptionType;

        public ExceptionalSymbolicValue(@Nullable Type exceptionType) {
            this.exceptionType = exceptionType;
        }

        @CheckForNull
        public Type exceptionType() {
            return this.exceptionType;
        }

        @Override
        public String toString() {
            return super.toString() + "_" + (this.exceptionType == null ? "!unknownException" : this.exceptionType.fullyQualifiedName()) + "!";
        }
    }

    public static abstract class UnarySymbolicValue
    extends SymbolicValue {
        protected SymbolicValue operand;
        private Symbol operandSymbol;

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public void computedFrom(List<ProgramState.SymbolicValueSymbol> symbolicValues) {
            Preconditions.checkArgument((symbolicValues.size() == 1 ? 1 : 0) != 0);
            this.operand = symbolicValues.get(0).symbolicValue();
            this.operandSymbol = symbolicValues.get(0).symbol();
        }

        @Override
        public List<SymbolicValue> computedFrom() {
            return Collections.singletonList(this.operand);
        }

        @Override
        public List<Symbol> computedFromSymbols() {
            return this.operandSymbol == null ? this.operand.computedFromSymbols() : Collections.singletonList(this.operandSymbol);
        }
    }
}

