/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJrtWithReleaseOption
extends ClasspathJrt {
    static String MODULE_INFO = "module-info.sig";
    final String release;
    String releaseInHex;
    private FileSystem fs;
    protected Path releasePath;
    protected Path modulePath;
    private String modPathString;
    private CtSym ctSym;

    public ClasspathJrtWithReleaseOption(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, String release) throws CoreException {
        if (release == null || release.equals("")) {
            throw new IllegalArgumentException("--release argument can not be null");
        }
        this.setZipFile(zipFilename);
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.release = this.getReleaseOptionFromCompliance(release);
        try {
            this.ctSym = JRTUtil.getCtSym(Paths.get(this.zipFilename, new String[0]).getParent().getParent());
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, ClasspathJrtWithReleaseOption.class, "Failed to init ct.sym for " + this.zipFilename, (Throwable)e));
        }
        this.initialize();
        this.loadModules();
    }

    private String getReleaseOptionFromCompliance(String comp) {
        if (JavaCore.compareJavaVersions(comp, "1.5") <= 0) {
            return "6";
        }
        int index = comp.indexOf("1.");
        if (index != -1) {
            return comp.substring(index + 2, comp.length());
        }
        return comp;
    }

    protected void initialize() throws CoreException {
        this.releaseInHex = Integer.toHexString(Integer.parseInt(this.release)).toUpperCase();
        this.fs = this.ctSym.getFs();
        this.releasePath = this.ctSym.getRoot();
        Path modPath = this.fs.getPath(String.valueOf(this.releaseInHex) + (this.ctSym.isJRE12Plus() ? "" : "-modules"), new String[0]);
        if (Files.exists(modPath, new LinkOption[0])) {
            this.modulePath = modPath;
            this.modPathString = String.valueOf(this.zipFilename) + "|" + modPath.toString();
        }
        if (!Files.exists(this.releasePath.resolve(this.releaseInHex), new LinkOption[0])) {
            IllegalArgumentException e = new IllegalArgumentException("release " + this.release + " is not found in the system");
            throw new CoreException(new Status(4, "org.eclipse.jdt.core", e.getMessage(), (Throwable)e));
        }
        if (Files.exists(this.fs.getPath(this.releaseInHex, "system-modules"), new LinkOption[0])) {
            this.fs = null;
        }
    }

    HashMap<String, SimpleSet> findPackagesInModules() {
        if (this.fs == null || !this.ctSym.isJRE12Plus()) {
            return ClasspathJrt.findPackagesInModules(this);
        }
        HashMap cache = (HashMap)PackageCache.get(this.modPathString);
        if (cache != null) {
            return cache;
        }
        final HashMap<String, SimpleSet> packagesInModule = new HashMap<String, SimpleSet>();
        PackageCache.put(this.modPathString, packagesInModule);
        try {
            JRTUtil.walkModuleImage(this.jrtFile, this.release, new JRTUtil.JrtFileVisitor<Path>(){
                SimpleSet packageSet = null;

                @Override
                public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                    ClasspathJar.addToPackageSet(this.packageSet, dir.toString(), true);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, Path mod, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitModule(Path path, String name) throws IOException {
                    this.packageSet = new SimpleSet(41);
                    this.packageSet.add("");
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    packagesInModule.put(name, this.packageSet);
                    return FileVisitResult.CONTINUE;
                }
            }, 6);
        }
        catch (IOException iOException) {}
        return packagesInModule;
    }

    public void loadModules() {
        if (this.fs == null || !this.ctSym.isJRE12Plus()) {
            ClasspathJrt.loadModules(this);
            return;
        }
        if (this.modPathString == null) {
            return;
        }
        HashMap cache = (HashMap)ModulesCache.get(this.modPathString);
        if (cache == null) {
            List<Path> releaseRoots = this.ctSym.releaseRoots(this.releaseInHex);
            for (Path root : releaseRoots) {
                try {
                    Files.walkFileTree(root, Collections.EMPTY_SET, 2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isDirectory() || f.getNameCount() < 3) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (f.getFileName().toString().equals(MODULE_INFO)) {
                                byte[] content = ClasspathJrtWithReleaseOption.this.ctSym.getFileBytes(f);
                                if (content == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                ClasspathJrtWithReleaseOption.this.acceptModule(content, f.getParent().getFileName().toString());
                            }
                            return FileVisitResult.SKIP_SIBLINGS;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path f, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (this.fs == null) {
            return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
        }
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        List<Path> releaseRoots = this.ctSym.releaseRoots(this.releaseInHex);
        try {
            ClassFileReader reader = null;
            byte[] content = null;
            String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
            if (!releaseRoots.isEmpty()) {
                Path fullPath = this.ctSym.getFullPath(this.releaseInHex, qualifiedBinaryFileName = qualifiedBinaryFileName.replace(".class", ".sig"), moduleName);
                if (fullPath != null && (content = this.ctSym.getFileBytes(fullPath)) != null) {
                    reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                    if (moduleName != null) {
                        reader.moduleName = moduleName.toCharArray();
                    }
                }
            } else {
                reader = ClassFileReader.readFromModule(this.jrtFile, moduleName, qualifiedBinaryFileName, moduleNameFilter);
            }
            return this.createAnswer(fileNameWithoutExtension, reader);
        }
        catch (IOException | ClassFormatException exception) {
            return null;
        }
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        HashMap<String, SimpleSet> cache = this.findPackagesInModules();
        if (cache != null) {
            return this.selectModules(cache.keySet(), limitModules);
        }
        return Collections.emptyList();
    }

    @Override
    public void cleanup() {
        try {
            super.cleanup();
        }
        finally {
            this.fs = null;
            this.ctSym = null;
        }
    }

    @Override
    public boolean hasModule() {
        return this.fs == null ? super.hasModule() : this.modPathString != null;
    }

    @Override
    protected String getKey() {
        return this.fs == null ? super.getKey() : this.modPathString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrtWithReleaseOption)) {
            return false;
        }
        ClasspathJrtWithReleaseOption jar = (ClasspathJrtWithReleaseOption)o;
        if (!Util.equalOrNull(this.release, jar.release)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
        return Util.combineHashCodes(hash, this.release.hashCode());
    }

    @Override
    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename + " with --release option " + this.release;
        return start;
    }
}

