/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.processing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class JobManager
implements Runnable {
    protected List<IJob> awaitingJobs = new LinkedList<IJob>();
    protected volatile boolean executing;
    protected volatile Thread processingThread;
    protected Job progressJob;
    private int enableCount = 1;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;
    private final Object idleMonitor = new Object();

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.awaitingJobs.size() : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && !this.awaitingJobs.isEmpty()) {
            return this.awaitingJobs.get(0);
        }
        return null;
    }

    public synchronized void disable() {
        --this.enableCount;
        if (VERBOSE) {
            Util.verbose("DISABLING background indexing");
        }
    }

    public synchronized boolean isEnabled() {
        return this.enableCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        if (VERBOSE) {
            Util.verbose("DISCARD   background job family - " + jobFamily);
        }
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        if (VERBOSE) {
                            Util.verbose("-> waiting end of current background job - " + currentJob);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            jobManager = this;
            synchronized (jobManager) {
                Iterator<IJob> it = this.awaitingJobs.iterator();
                while (it.hasNext()) {
                    currentJob = it.next();
                    if (jobFamily != null && !currentJob.belongsTo(jobFamily)) continue;
                    if (VERBOSE) {
                        Util.verbose("-> discarding background job  - " + currentJob);
                    }
                    currentJob.cancel();
                    it.remove();
                }
            }
        }
        finally {
            this.enable();
        }
        if (VERBOSE) {
            Util.verbose("DISCARD   DONE with background job family - " + jobFamily);
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        if (VERBOSE) {
            Util.verbose("ENABLING  background indexing");
        }
        this.notifyAll();
    }

    protected synchronized boolean isJobWaiting(IJob request) {
        if (this.awaitingJobs.size() <= 1) {
            return false;
        }
        ListIterator<IJob> iterator = this.awaitingJobs.listIterator(this.awaitingJobs.size());
        IJob first = this.awaitingJobs.get(0);
        while (iterator.hasPrevious()) {
            IJob job = iterator.previous();
            if (job == first) break;
            if (!request.equals(job)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void moveToNextJob() {
        if (!this.awaitingJobs.isEmpty()) {
            this.awaitingJobs.remove(0);
            if (this.awaitingJobsCount() == 0) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.notifyAll();
                }
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor monitor) {
        if (VERBOSE) {
            Util.verbose("STARTING  concurrent job - " + searchJob);
        }
        searchJob.ensureReadyToRun();
        boolean status = false;
        try {
            SubMonitor subMonitor;
            block47: {
                subMonitor = SubMonitor.convert(monitor);
                if (this.awaitingJobsCount() <= 0) break block47;
                switch (waitingPolicy) {
                    case 1: {
                        if (VERBOSE) {
                            Util.verbose("-> NOT READY - forcing immediate - " + searchJob);
                        }
                        try {
                            this.disable();
                            status = searchJob.execute(subMonitor);
                        }
                        finally {
                            this.enable();
                        }
                        if (VERBOSE) {
                            Util.verbose("FINISHED  concurrent job - " + searchJob);
                        }
                        boolean bl = status;
                        return bl;
                    }
                    case 2: {
                        if (VERBOSE) {
                            Util.verbose("-> NOT READY - cancelling - " + searchJob);
                        }
                        if (VERBOSE) {
                            Util.verbose("CANCELED concurrent job - " + searchJob);
                        }
                        throw new OperationCanceledException();
                    }
                    case 3: {
                        int totalWork = 1000;
                        SubMonitor waitMonitor = subMonitor.setWorkRemaining(10).split(8).setWorkRemaining(totalWork);
                        Thread t = this.processingThread;
                        int originalPriority = t == null ? -1 : t.getPriority();
                        try {
                            int awaitingJobsCount;
                            if (t != null) {
                                t.setPriority(Thread.currentThread().getPriority());
                            }
                            JobManager jobManager = this;
                            synchronized (jobManager) {
                                ++this.awaitingClients;
                            }
                            IJob previousJob = null;
                            int lastJobsCount = totalWork;
                            float lastWorked = 0.0f;
                            float totalWorked = 0.0f;
                            while ((awaitingJobsCount = this.awaitingJobsCount()) > 0) {
                                Object object;
                                if (waitMonitor.isCanceled() || this.processingThread == null) {
                                    throw new OperationCanceledException();
                                }
                                IJob currentJob = this.currentJob();
                                if (currentJob != null) {
                                    object = this.idleMonitor;
                                    synchronized (object) {
                                        this.idleMonitor.notifyAll();
                                    }
                                }
                                if (currentJob != null && currentJob != previousJob) {
                                    float ratio;
                                    if (VERBOSE) {
                                        Util.verbose("-> NOT READY - waiting until ready - " + searchJob);
                                    }
                                    String indexing = Messages.bind(Messages.jobmanager_filesToIndex, currentJob.getJobFamily(), Integer.toString(awaitingJobsCount));
                                    waitMonitor.subTask(indexing);
                                    float f = ratio = awaitingJobsCount < totalWork ? 1.0f : (float)totalWork / (float)awaitingJobsCount;
                                    totalWorked = lastJobsCount > awaitingJobsCount ? (totalWorked += (float)(lastJobsCount - awaitingJobsCount) * ratio) : (totalWorked += ratio);
                                    if (totalWorked - lastWorked >= 1.0f) {
                                        waitMonitor.worked((int)(totalWorked - lastWorked));
                                        lastWorked = totalWorked;
                                    }
                                    lastJobsCount = awaitingJobsCount;
                                    previousJob = currentJob;
                                }
                                object = this;
                                synchronized (object) {
                                    if (this.awaitingJobsCount() > 0) {
                                        try {
                                            this.wait(50L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            JobManager jobManager = this;
                            synchronized (jobManager) {
                                --this.awaitingClients;
                            }
                            if (t != null && originalPriority > -1 && t.isAlive()) {
                                t.setPriority(originalPriority);
                            }
                            throw throwable;
                        }
                        JobManager jobManager = this;
                        synchronized (jobManager) {
                            --this.awaitingClients;
                        }
                        if (t == null || originalPriority <= -1 || !t.isAlive()) break;
                        t.setPriority(originalPriority);
                    }
                }
            }
            status = searchJob.execute(subMonitor);
        }
        finally {
            SubMonitor.done(monitor);
            if (VERBOSE) {
                Util.verbose("FINISHED  concurrent job - " + searchJob);
            }
        }
        return status;
    }

    public abstract String processName();

    public synchronized void requestIfNotWaiting(IJob job) {
        if (!this.isJobWaiting(job)) {
            this.request(job);
        }
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        this.awaitingJobs.add(job);
        if (VERBOSE) {
            Util.verbose("REQUEST   background job - " + job);
            Util.verbose("AWAITING JOBS count: " + this.awaitingJobsCount());
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Thread thread;
        if (VERBOSE) {
            Util.verbose("Reset");
        }
        JobManager jobManager = this;
        synchronized (jobManager) {
            thread = this.processingThread;
        }
        if (thread != null) {
            this.discardJobs(null);
        } else {
            jobManager = this;
            synchronized (jobManager) {
                this.processingThread = new Thread((Runnable)this, this.processName());
                this.processingThread.setDaemon(true);
                this.processingThread.setPriority(4);
                this.processingThread.setContextClassLoader(this.getClass().getClassLoader());
                this.processingThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            this.progressJob = null;
            while (this.processingThread != null) {
                try {
                    Object object;
                    IJob job;
                    Object object2 = this;
                    synchronized (object2) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        job = this.currentJob();
                        if (job == null) {
                            if (this.progressJob != null) {
                                this.progressJob.cancel();
                                this.progressJob = null;
                            }
                            if (idlingStart < 0L) {
                                idlingStart = System.currentTimeMillis();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            }
                            this.wait();
                        } else {
                            idlingStart = -1L;
                        }
                    }
                    if (job == null) {
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        object2 = this.idleMonitor;
                        synchronized (object2) {
                            this.idleMonitor.wait(500L);
                            continue;
                        }
                    }
                    if (VERBOSE) {
                        Util.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        Util.verbose("STARTING background job - " + job);
                    }
                    try {
                        this.executing = true;
                        if (this.progressJob == null) {
                            class ProgressJob
                            extends Job {
                                ProgressJob(String name) {
                                    super(name);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                protected IStatus run(IProgressMonitor monitor) {
                                    IJob job = JobManager.this.currentJob();
                                    while (!monitor.isCanceled() && job != null) {
                                        String taskName = new StringBuffer(Messages.jobmanager_indexing).append(Messages.bind(Messages.jobmanager_filesToIndex, job.getJobFamily(), Integer.toString(JobManager.this.awaitingJobsCount()))).toString();
                                        monitor.subTask(taskName);
                                        this.setName(taskName);
                                        JobManager jobManager = JobManager.this;
                                        synchronized (jobManager) {
                                            if (JobManager.this.currentJob() != null) {
                                                try {
                                                    JobManager.this.wait(500L);
                                                }
                                                catch (InterruptedException interruptedException) {}
                                            }
                                        }
                                        job = JobManager.this.currentJob();
                                    }
                                    return Status.OK_STATUS;
                                }
                            }
                            this.progressJob = new ProgressJob(Messages.bind(Messages.jobmanager_indexing, "", ""));
                            this.progressJob.setPriority(30);
                            this.progressJob.setSystem(true);
                            this.progressJob.schedule();
                        }
                        job.execute(null);
                    }
                    catch (Throwable throwable) {
                        this.executing = false;
                        if (VERBOSE) {
                            Util.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients == 0 && job.waitNeeded()) {
                            if (VERBOSE) {
                                Util.verbose("WAITING after job - " + job);
                            }
                            object = this.idleMonitor;
                            synchronized (object) {
                                this.idleMonitor.wait(5L);
                            }
                        }
                        throw throwable;
                    }
                    this.executing = false;
                    if (VERBOSE) {
                        Util.verbose("FINISHED background job - " + job);
                    }
                    this.moveToNextJob();
                    if (this.awaitingClients != 0 || !job.waitNeeded()) continue;
                    if (VERBOSE) {
                        Util.verbose("WAITING after job - " + job);
                    }
                    object = this.idleMonitor;
                    synchronized (object) {
                        this.idleMonitor.wait(5L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread != null) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
        catch (Error e) {
            if (this.processingThread != null && !(e instanceof ThreadDeath)) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (VERBOSE) {
            Util.verbose("Shutdown");
        }
        this.disable();
        this.discardJobs(null);
        Thread thread = this.processingThread;
        try {
            Job job;
            if (thread != null) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            if ((job = this.progressJob) != null) {
                job.cancel();
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(10);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.awaitingJobs.size();
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs.get(i)).append('\n');
            ++i;
        }
        return buffer.toString();
    }
}

