/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S3011")
public class AccessibilityChangeCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_REFLECT_FIELD = "java.lang.reflect.Field";
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.lang.reflect.AccessibleObject").names("setAccessible").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("set").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setBoolean").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setByte").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setChar").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setDouble").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setFloat").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setInt").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setLong").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.reflect.Field").names("setShort").withAnyParameters().build());

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("setAccessible")) {
            this.checkAccessibilityUpdate(mit);
        } else {
            this.reportIssue(mit, "This accessibility bypass should be removed.");
        }
    }

    private void checkAccessibilityUpdate(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        ExpressionTree arg = (ExpressionTree)arguments.get(0);
        if (arguments.size() > 1) {
            arg = (ExpressionTree)arguments.get(1);
        }
        if (Boolean.TRUE.equals(ExpressionsHelper.getConstantValueAsBoolean(arg).value())) {
            this.reportIssue(mit, "This accessibility update should be removed.");
        }
    }
}

