/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractHashAlgorithmChecker;
import org.sonar.java.collections.MapBuilder;

@Rule(key="S2070")
public class DeprecatedHashAlgorithmCheck
extends AbstractHashAlgorithmChecker {
    private static final String MESSAGE_FORMAT = "Don't rely on %s because it is deprecated and use a stronger hashing algorithm.";
    private static final Map<String, String> MESSAGE_PER_CLASS = MapBuilder.newMap().put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD5.classFqn, "Use a stronger hashing algorithm than MD5.").put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.classFqn, "Don't rely on " + AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.className + " because it is deprecated.").put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.classFqn, String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.className)).put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.classFqn, String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.className)).put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.classFqn, String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.className)).put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.NO_OP.classFqn, "Use a stronger hashing algorithm than this fake one.").put(AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.STANDARD.classFqn, "Use a stronger hashing algorithm.").build();

    @Override
    protected Optional<String> getMessageForClass(String className) {
        return Optional.ofNullable(MESSAGE_PER_CLASS.get(className));
    }

    @Override
    protected String getMessageForAlgorithm(String algorithmName) {
        return "Use a stronger hashing algorithm than " + algorithmName + ".";
    }
}

