/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2165")
public class FinalizeFieldsSetCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (FinalizeFieldsSetCheck.isFinalizeDeclaration(methodTree)) {
            methodTree.accept(new AssignmentVisitor());
        }
    }

    private static boolean isFinalizeDeclaration(MethodTree tree) {
        return FinalizeFieldsSetCheck.isMethodNamedFinalize(tree) && FinalizeFieldsSetCheck.hasNoParameters(tree);
    }

    private static boolean isMethodNamedFinalize(MethodTree tree) {
        return "finalize".equals(tree.simpleName().name());
    }

    private static boolean hasNoParameters(MethodTree tree) {
        return tree.parameters().isEmpty();
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (this.isFieldAssignment(tree) && this.isNullAssignment(tree)) {
                FinalizeFieldsSetCheck.this.reportIssue(tree.expression(), "Remove this nullification of \"" + this.getFieldName(tree) + "\".");
            }
        }

        private boolean isFieldAssignment(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)variable;
                if (!ExpressionUtils.isThis(memberSelectExpressionTree.expression())) {
                    return false;
                }
                variable = memberSelectExpressionTree.identifier();
            }
            if (variable.is(Tree.Kind.IDENTIFIER)) {
                Symbol variableSymbol = ((IdentifierTree)variable).symbol();
                return variableSymbol.owner().isTypeSymbol();
            }
            return false;
        }

        private boolean isNullAssignment(AssignmentExpressionTree tree) {
            return tree.expression().is(Tree.Kind.NULL_LITERAL);
        }

        private String getFieldName(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(Tree.Kind.MEMBER_SELECT)) {
                variable = ((MemberSelectExpressionTree)variable).identifier();
            }
            return ((IdentifierTree)variable).name();
        }
    }
}

