/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1150")
public class ImplementsEnumerationCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (TypeTree superInterface : classTree.superInterfaces()) {
            IdentifierTree identifierTree = null;
            if (superInterface.is(Tree.Kind.IDENTIFIER)) {
                identifierTree = (IdentifierTree)superInterface;
            } else if (superInterface.is(Tree.Kind.PARAMETERIZED_TYPE) && ((ParameterizedTypeTree)superInterface).type().is(Tree.Kind.IDENTIFIER)) {
                identifierTree = (IdentifierTree)((ParameterizedTypeTree)superInterface).type();
            }
            if (!ImplementsEnumerationCheck.isEnumeration(identifierTree)) continue;
            this.reportIssue(superInterface, "Implement Iterator rather than Enumeration.");
        }
    }

    private static boolean isEnumeration(@Nullable IdentifierTree tree) {
        return tree != null && "Enumeration".equals(tree.name());
    }
}

