/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1850")
public class InstanceOfAlwaysTrueCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INSTANCE_OF);
    }

    @Override
    public void visitNode(Tree tree) {
        Type instanceOf;
        InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
        Type expressionType = instanceOfTree.expression().symbolType();
        if (expressionType.isSubtypeOf(instanceOf = instanceOfTree.type().symbolType()) && !instanceOfTree.expression().is(Tree.Kind.NULL_LITERAL)) {
            this.reportIssue(instanceOfTree.instanceofKeyword(), "Remove this useless \"instanceof\" operator; it will always return \"true\". ");
        }
    }
}

