/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5612")
public class LambdaTooBigCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(key="Max", description="Maximum allowed lines in a lambda", defaultValue="10")
    public int max = 10;
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        int lines = LambdaTooBigCheck.getNumberOfLines(lambdaExpressionTree);
        if (lines > this.max) {
            SyntaxToken firstToken = lambdaExpressionTree.firstToken();
            SyntaxToken lastSyntaxToken = lambdaExpressionTree.lastToken();
            JavaFileScannerContext.Location lastTokenLocation = new JavaFileScannerContext.Location(lines + " lines", lastSyntaxToken);
            this.context.reportIssue(this, firstToken, lambdaExpressionTree.arrowToken(), "Reduce this lambda expression number of lines from " + lines + " to at most " + this.max + ".", Collections.singletonList(lastTokenLocation), null);
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private static int getNumberOfLines(Tree tree) {
        return new LinesOfCodeVisitor().linesOfCode(tree);
    }
}

