/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S4508")
public class ObjectDeserializationCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure deserializing objects is safe here.";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes("java.io.ObjectInputStream").names("readObject", "readUnshared").addWithoutParametersMatcher().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(mit, MESSAGE);
    }
}

