/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2277")
public class RSAUsesOAEPCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.STRING_LITERAL);
    }

    @Override
    public void visitNode(Tree tree) {
        LiteralTree lt = (LiteralTree)tree;
        if (RSAUsesOAEPCheck.isRSA(LiteralUtils.trimQuotes(lt.value()))) {
            this.reportIssue(lt, "Use an RSA algorithm with an OAEP (Optimal Asymmetric Encryption Padding).");
        }
    }

    private static boolean isRSA(String algorithmName) {
        return algorithmName.startsWith("RSA/NONE");
    }
}

