/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1147")
public class SystemExitCalledCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.CONSTRUCTOR) || !MethodTreeUtils.isMainMethod((MethodTree)tree)) {
            tree.accept(new InvocationVisitor());
        }
    }

    private class InvocationVisitor
    extends BaseTreeVisitor {
        private String idName;

        private InvocationVisitor() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.isCallToExitMethod(tree)) {
                SystemExitCalledCheck.this.reportIssue(tree.methodSelect(), "Remove this call to \"" + this.idName + "\" or ensure it is really required.");
            }
        }

        private boolean isCallToExitMethod(MethodInvocationTree tree) {
            String selection = this.concatenate(tree.methodSelect());
            return "System.exit".equals(selection) || "Runtime.getRuntime().exit".equals(selection) || "Runtime.getRuntime().halt".equals(selection);
        }

        private String concatenate(ExpressionTree tree) {
            LinkedList<String> pieces = new LinkedList<String>();
            ExpressionTree expr = tree;
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                pieces.push(mse.identifier().name());
                pieces.push(".");
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.METHOD_INVOCATION)) {
                pieces.push("()");
                pieces.push(this.concatenate(((MethodInvocationTree)expr).methodSelect()));
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree idt = (IdentifierTree)expr;
                pieces.push(idt.name());
            }
            StringBuilder sb = new StringBuilder();
            this.idName = (String)pieces.getLast();
            for (String piece : pieces) {
                sb.append(piece);
            }
            return sb.toString();
        }
    }
}

