/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.SyntaxError;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5856")
public class InvalidRegexCheck
extends AbstractRegexCheck {
    private static final String ERROR_MESSAGE = "Fix the syntax error%s inside this regex.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        List<SyntaxError> syntaxErrors = regexForLiterals.getSyntaxErrors();
        if (!syntaxErrors.isEmpty()) {
            this.reportSyntaxErrors(syntaxErrors);
        }
    }

    private void reportSyntaxErrors(List<SyntaxError> syntaxErrors) {
        RegexSyntaxElement tree = syntaxErrors.get(0).getOffendingSyntaxElement();
        List<RegexCheck.RegexIssueLocation> secondaries = syntaxErrors.stream().map(error -> new RegexCheck.RegexIssueLocation(error.getOffendingSyntaxElement(), error.getMessage())).collect(Collectors.toList());
        this.reportIssue(tree, secondaries);
    }

    private void reportIssue(RegexSyntaxElement tree, List<RegexCheck.RegexIssueLocation> secondaries) {
        String msg = String.format(ERROR_MESSAGE, secondaries.size() > 1 ? "s" : "");
        this.reportIssue(tree, msg, null, secondaries);
    }
}

