/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S4432")
public class AESAlgorithmCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("javax.crypto.Cipher").names("getInstance").withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().isEmpty()) {
            return;
        }
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArgument);
        ExpressionTree algorithmTree = defaultPropertyValue == null ? firstArgument : defaultPropertyValue;
        String algorithmName = ExpressionsHelper.getConstantValueAsString(algorithmTree).value();
        if (algorithmName != null && AESAlgorithmCheck.isInsecureAESAlgorithm(algorithmName)) {
            this.reportIssue(firstArgument, "Use Galois/Counter Mode (GCM/NoPadding) instead.");
        }
    }

    private static boolean isInsecureAESAlgorithm(String algorithmName) {
        return algorithmName.startsWith("AES/ECB/") || "AES/CBC/PKCS5Padding".equals(algorithmName);
    }
}

