/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S4787")
public class DataEncryptionCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("javax.crypto.Cipher").names("getInstance").withAnyParameters().build(), MethodMatchers.create().ofTypes("org.apache.commons.crypto.utils.Utils").names("getCipherInstance").withAnyParameters().build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), "Make sure that encrypting data is safe here.");
    }
}

