/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4784")
public class RegexHotspotCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers REGEX_HOTSPOTS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.String").names("matches").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.lang.String").names("replaceAll", "replaceFirst").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.util.regex.Pattern").names("compile", "matches").withAnyParameters().build());
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final List<String> HOTSPOT_ANNOTATION_TYPES = Arrays.asList("javax.validation.constraints.Pattern", "javax.validation.constraints.Email", "org.hibernate.validator.constraints.URL");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.ANNOTATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            Arguments args;
            if (REGEX_HOTSPOTS.matches((MethodInvocationTree)tree) && !(args = ((MethodInvocationTree)tree).arguments()).isEmpty() && RegexHotspotCheck.isSuspiciousRegex((ExpressionTree)args.get(0))) {
                this.reportIssue((Tree)args.get(0), MESSAGE);
            }
        } else {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            if (HOTSPOT_ANNOTATION_TYPES.stream().anyMatch(t -> annotationTree.annotationType().symbolType().is((String)t))) {
                annotationTree.arguments().stream().filter(RegexHotspotCheck::isRegexpParameter).findFirst().ifPresent(e -> this.reportIssue((Tree)e, MESSAGE));
            }
        }
    }

    private static boolean isRegexpParameter(ExpressionTree expr) {
        if (expr.is(Tree.Kind.ASSIGNMENT) && ((AssignmentExpressionTree)expr).variable().is(Tree.Kind.IDENTIFIER)) {
            AssignmentExpressionTree aet = (AssignmentExpressionTree)expr;
            IdentifierTree variable = (IdentifierTree)aet.variable();
            return variable.name().equals("regexp") && RegexHotspotCheck.isSuspiciousRegex(aet.expression());
        }
        return false;
    }

    private static boolean isSuspiciousRegex(ExpressionTree exp) {
        String regexp = ExpressionsHelper.getConstantValueAsString(exp).value();
        if (regexp != null && regexp.length() > 2) {
            int nOfSuspiciousChars = regexp.length() - regexp.replaceAll("[*+{]", "").length();
            return nOfSuspiciousChars > 1;
        }
        return false;
    }
}

