/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.cfg.VariableReadExtractor;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1854")
public class DeadStoreCheck
extends IssuableSubscriptionVisitor {
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null) {
            return;
        }
        if (DeadStoreCheck.hasTryFinallyWithLocalVar(methodTree.block(), methodTree.symbol())) {
            return;
        }
        UNRESOLVED_IDENTIFIERS_VISITOR.check(methodTree);
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        CFG cfg = CFG.build(methodTree);
        LiveVariables liveVariables = LiveVariables.analyze(cfg);
        for (CFG.Block block : cfg.blocks()) {
            this.checkElements(block, liveVariables.getOut(block), methodSymbol);
        }
    }

    private void checkElements(CFG.Block block, Set<Symbol> blockOut, Symbol.MethodSymbol methodSymbol) {
        HashSet<Symbol> out = new HashSet<Symbol>(blockOut);
        HashSet assignmentLHS = new HashSet();
        new ArrayDeque<Tree>(block.elements()).descendingIterator().forEachRemaining(element -> this.checkElement(methodSymbol, (Set<Symbol>)out, assignmentLHS, (Tree)element));
    }

    private Set<Symbol> checkElement(Symbol.MethodSymbol methodSymbol, Set<Symbol> outVar, Set<Tree> assignmentLHS, Tree element) {
        Set<Symbol> out = outVar;
        switch (element.kind()) {
            case PLUS_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case ASSIGNMENT: {
                this.handleAssignment(out, assignmentLHS, (AssignmentExpressionTree)element);
                break;
            }
            case IDENTIFIER: {
                DeadStoreCheck.handleIdentifier(out, assignmentLHS, (IdentifierTree)element);
                break;
            }
            case VARIABLE: {
                this.handleVariable(out, (VariableTree)element);
                break;
            }
            case NEW_CLASS: {
                DeadStoreCheck.handleNewClass(out, methodSymbol, (NewClassTree)element);
                break;
            }
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree lambda = (LambdaExpressionTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(lambda.body(), methodSymbol));
                break;
            }
            case METHOD_REFERENCE: {
                MethodReferenceTree methodRef = (MethodReferenceTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(methodRef.expression(), methodSymbol));
                break;
            }
            case TRY_STATEMENT: {
                DeadStoreCheck.handleTryStatement(out, methodSymbol, (TryStatementTree)element);
                break;
            }
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                this.handlePrefixExpression(out, (UnaryExpressionTree)element);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                this.handlePostfixExpression(out, (UnaryExpressionTree)element);
                break;
            }
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                ClassTree classTree = (ClassTree)element;
                out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(classTree, methodSymbol));
                break;
            }
        }
        return out;
    }

    private void handleAssignment(Set<Symbol> out, Set<Tree> assignmentLHS, AssignmentExpressionTree element) {
        ExpressionTree lhs = ExpressionUtils.skipParentheses(element.variable());
        if (lhs.is(Tree.Kind.IDENTIFIER)) {
            Symbol symbol = ((IdentifierTree)lhs).symbol();
            if (JUtils.isLocalVariable(symbol) && !out.contains(symbol) && (element.is(Tree.Kind.ASSIGNMENT) || DeadStoreCheck.isParentExpressionStatement(element)) && !UNRESOLVED_IDENTIFIERS_VISITOR.isUnresolved(symbol.name())) {
                this.createIssue(element.operatorToken(), element.expression(), symbol);
            }
            assignmentLHS.add(lhs);
            if (element.is(Tree.Kind.ASSIGNMENT)) {
                out.remove(symbol);
            } else {
                out.add(symbol);
            }
        }
    }

    private static boolean isParentExpressionStatement(Tree element) {
        return element.parent().is(Tree.Kind.EXPRESSION_STATEMENT);
    }

    private static void handleIdentifier(Set<Symbol> out, Set<Tree> assignmentLHS, IdentifierTree element) {
        Symbol symbol = element.symbol();
        if (!assignmentLHS.contains(element) && JUtils.isLocalVariable(symbol)) {
            out.add(symbol);
        }
    }

    private void handleVariable(Set<Symbol> out, VariableTree localVar) {
        Symbol symbol = localVar.symbol();
        ExpressionTree initializer = localVar.initializer();
        if (!(initializer == null || DeadStoreCheck.isUsualDefaultValue(initializer) || out.contains(symbol) || UNRESOLVED_IDENTIFIERS_VISITOR.isUnresolved(symbol.name()))) {
            this.createIssue(localVar.equalToken(), initializer, symbol);
        }
        out.remove(symbol);
    }

    private static boolean isUsualDefaultValue(ExpressionTree tree) {
        ExpressionTree expr = ExpressionUtils.skipParentheses(tree);
        switch (expr.kind()) {
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                return true;
            }
            case STRING_LITERAL: {
                return LiteralUtils.isEmptyString(expr);
            }
            case INT_LITERAL: {
                String value = ((LiteralTree)expr).value();
                return "0".equals(value) || "1".equals(value);
            }
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                return DeadStoreCheck.isUsualDefaultValue(((UnaryExpressionTree)expr).expression());
            }
        }
        return false;
    }

    private static void handleNewClass(Set<Symbol> out, Symbol.MethodSymbol methodSymbol, NewClassTree element) {
        ClassTree body = element.classBody();
        if (body != null) {
            out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(body, methodSymbol));
        }
    }

    private static void handleTryStatement(Set<Symbol> out, Symbol.MethodSymbol methodSymbol, TryStatementTree element) {
        AssignedLocalVarVisitor visitor = new AssignedLocalVarVisitor();
        element.block().accept(visitor);
        out.addAll(visitor.assignedLocalVars);
        for (CatchTree catchTree : element.catches()) {
            out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(catchTree, methodSymbol));
        }
    }

    private void handlePrefixExpression(Set<Symbol> out, UnaryExpressionTree element) {
        Symbol symbol;
        ExpressionTree expression = element.expression();
        if (DeadStoreCheck.isParentExpressionStatement(element) && expression.is(Tree.Kind.IDENTIFIER) && JUtils.isLocalVariable(symbol = ((IdentifierTree)expression).symbol()) && !out.contains(symbol)) {
            this.createIssue(element, symbol);
        }
    }

    private void handlePostfixExpression(Set<Symbol> out, UnaryExpressionTree element) {
        Symbol symbol;
        ExpressionTree expression = ExpressionUtils.skipParentheses(element.expression());
        if (expression.is(Tree.Kind.IDENTIFIER) && JUtils.isLocalVariable(symbol = ((IdentifierTree)expression).symbol()) && !out.contains(symbol)) {
            this.createIssue(element, symbol);
        }
    }

    private void createIssue(Tree element, Symbol symbol) {
        this.reportIssue(element, DeadStoreCheck.getMessage(symbol));
    }

    private void createIssue(Tree startTree, Tree endTree, Symbol symbol) {
        this.reportIssue(startTree, endTree, DeadStoreCheck.getMessage(symbol));
    }

    private static String getMessage(Symbol symbol) {
        return "Remove this useless assignment to local variable \"" + symbol.name() + "\".";
    }

    private static Set<Symbol> getUsedLocalVarInSubTree(Tree tree, Symbol.MethodSymbol methodSymbol) {
        VariableReadExtractor localVarExtractor = new VariableReadExtractor(methodSymbol, false);
        tree.accept(localVarExtractor);
        return localVarExtractor.usedVariables();
    }

    private static boolean hasTryFinallyWithLocalVar(BlockTree block, Symbol.MethodSymbol methodSymbol) {
        TryVisitor tryVisitor = new TryVisitor(methodSymbol);
        block.accept(tryVisitor);
        return tryVisitor.hasTryFinally;
    }

    private static class AssignedLocalVarVisitor
    extends BaseTreeVisitor {
        List<Symbol> assignedLocalVars = new ArrayList<Symbol>();

        private AssignedLocalVarVisitor() {
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree lhs = ExpressionUtils.skipParentheses(tree.variable());
            if (lhs.is(Tree.Kind.IDENTIFIER)) {
                Symbol symbol = ((IdentifierTree)lhs).symbol();
                if (JUtils.isLocalVariable(symbol)) {
                    this.assignedLocalVars.add(symbol);
                }
                super.visitAssignmentExpression(tree);
            }
        }
    }

    private static class TryVisitor
    extends BaseTreeVisitor {
        boolean hasTryFinally = false;
        Symbol.MethodSymbol methodSymbol;

        TryVisitor(Symbol.MethodSymbol methodSymbol) {
            this.methodSymbol = methodSymbol;
        }

        @Override
        public void visitTryStatement(TryStatementTree tree) {
            BlockTree finallyBlock = tree.finallyBlock();
            this.hasTryFinally |= finallyBlock != null && !DeadStoreCheck.getUsedLocalVarInSubTree(finallyBlock, this.methodSymbol).isEmpty() || !tree.resourceList().isEmpty();
            if (!this.hasTryFinally) {
                super.visitTryStatement(tree);
            }
        }

        @Override
        public void visitClass(ClassTree tree) {
        }
    }
}

