/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1695")
public class NPEThrowCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.THROW_STATEMENT, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.THROW_STATEMENT)) {
            ExpressionTree expressionTree = ((ThrowStatementTree)tree).expression();
            this.raiseIssueOnNpe(expressionTree, expressionTree.symbolType());
        } else {
            for (TypeTree throwClause : ((MethodTree)tree).throwsClauses()) {
                this.raiseIssueOnNpe(throwClause, throwClause.symbolType());
            }
        }
    }

    private void raiseIssueOnNpe(Tree tree, Type type) {
        if (type.is("java.lang.NullPointerException")) {
            this.reportIssue(NPEThrowCheck.treeAtFault(tree), "Throw some other exception here, such as \"IllegalArgumentException\".");
        }
    }

    private static Tree treeAtFault(Tree tree) {
        return tree.is(Tree.Kind.NEW_CLASS) ? ((NewClassTree)tree).identifier() : tree;
    }
}

