/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3034")
public class RawByteBitwiseOperationsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    JavaFileScannerContext context;
    Set<ExpressionTree> shifts = new HashSet<ExpressionTree>();
    Set<ExpressionTree> byteContainments = new HashSet<ExpressionTree>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
        this.shifts.clear();
        this.byteContainments.clear();
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (RawByteBitwiseOperationsCheck.isShifting(tree)) {
            this.shifts.add(tree);
            return;
        }
        if (ExpressionUtils.isSecuringByte(tree)) {
            this.byteContainments.add(tree);
            return;
        }
        if (RawByteBitwiseOperationsCheck.isIntegerOrLongExpected(tree.symbolType())) {
            ExpressionTree leftOperand = ExpressionUtils.skipParentheses(tree.leftOperand());
            ExpressionTree rightOperand = ExpressionUtils.skipParentheses(tree.rightOperand());
            this.checkShiftWithoutByteSecuring(leftOperand, rightOperand);
            this.checkShiftWithoutByteSecuring(rightOperand, leftOperand);
        }
    }

    private static boolean isShifting(BinaryExpressionTree tree) {
        return tree.is(Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT);
    }

    private static boolean isIntegerOrLongExpected(Type type) {
        return type.isPrimitive(Type.Primitives.INT) || type.isPrimitive(Type.Primitives.LONG);
    }

    private void checkShiftWithoutByteSecuring(ExpressionTree shiftExpr, ExpressionTree byteExpr) {
        if (this.shifts.contains(shiftExpr) && !this.byteContainments.contains(byteExpr) && byteExpr.symbolType().isPrimitive(Type.Primitives.BYTE)) {
            this.context.reportIssue(this, byteExpr, "Prevent \"int\" promotion by adding \"& 0xff\" to this expression.");
        }
    }
}

