/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1656")
public class SelfAssignementCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Remove or correct this useless self-assignment.";
    private final Set<JWarning> warnings = new HashSet<JWarning>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.ASSIGNMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.warnings.clear();
            this.warnings.addAll(((JavaTree.CompilationUnitTreeImpl)tree).warnings(JWarning.Type.ASSIGNMENT_HAS_NO_EFFECT));
            return;
        }
        AssignmentExpressionTree node = (AssignmentExpressionTree)tree;
        if (SyntacticEquivalence.areEquivalent(node.expression(), node.variable())) {
            this.reportIssue(SelfAssignementCheck.reportTree(node), ISSUE_MESSAGE);
            this.updateWarnings(node);
        }
    }

    private static SyntaxToken reportTree(AssignmentExpressionTree node) {
        return node.operatorToken();
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.warnings.forEach(warning -> this.reportIssue(SelfAssignementCheck.reportTree((AssignmentExpressionTree)warning.syntaxTree()), ISSUE_MESSAGE));
        }
    }

    private void updateWarnings(AssignmentExpressionTree tree) {
        Iterator<JWarning> iterator = this.warnings.iterator();
        while (iterator.hasNext()) {
            JWarning warning = iterator.next();
            if (!tree.equals(warning.syntaxTree())) continue;
            iterator.remove();
        }
    }
}

