/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2209")
public class StaticMembersAccessCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    @Override
    public void visitNode(Tree tree) {
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        if (memberSelect.identifier().symbol().isStatic()) {
            ExpressionTree memberSelectExpression = memberSelect.expression();
            if (memberSelectExpression.is(Tree.Kind.MEMBER_SELECT)) {
                memberSelectExpression = ((MemberSelectExpressionTree)memberSelectExpression).identifier();
            }
            if (!memberSelectExpression.is(Tree.Kind.IDENTIFIER) || ((IdentifierTree)memberSelectExpression).symbol().isVariableSymbol()) {
                this.context.reportIssue(this, memberSelect, "Change this instance-reference to a static reference.");
            }
        }
    }
}

