/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3366")
public class ThisExposedFromConstructorCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        methodTree.block().accept(new ConstructorBodyVisitor(methodTree.symbol().owner()));
    }

    private class ConstructorBodyVisitor
    extends BaseTreeVisitor {
        private Symbol owner;

        public ConstructorBodyVisitor(Symbol owner) {
            this.owner = owner;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.owner == tree.symbol().owner()) {
                return;
            }
            tree.arguments().stream().filter(ExpressionUtils::isThis).forEach(this::report);
            super.visitMethodInvocation(tree);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            MemberSelectExpressionTree memberSelect;
            if (!ExpressionUtils.isThis(tree.expression())) {
                return;
            }
            ExpressionTree variable = tree.variable();
            if (variable.is(Tree.Kind.MEMBER_SELECT) ? (memberSelect = (MemberSelectExpressionTree)variable).expression().symbolType().symbol().equals(this.owner) && memberSelect.identifier().symbol().isStatic() : variable.is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)variable).symbol().isStatic()) {
                return;
            }
            this.report(tree);
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        private void report(ExpressionTree tree) {
            ThisExposedFromConstructorCheck.this.reportIssue(tree, "Make sure the use of \"this\" doesn't expose partially-constructed instances of this class in multi-threaded environments.");
        }
    }
}

