/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2093")
public class TryWithResourcesCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private final Deque<TryStatementTree> withinTry = new LinkedList<TryStatementTree>();
    private final Deque<List<Tree>> toReport = new LinkedList<List<Tree>>();

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        this.withinTry.clear();
        this.toReport.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TRY_STATEMENT, Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.TRY_STATEMENT)) {
            this.withinTry.push((TryStatementTree)tree);
            if (this.withinTry.size() != this.toReport.size()) {
                this.toReport.push(new ArrayList());
            }
        } else if (((NewClassTree)tree).symbolType().isSubtypeOf("java.lang.AutoCloseable")) {
            if (this.withinStandardTryWithFinally()) {
                this.toReport.peek().add(tree);
            } else if (TryWithResourcesCheck.isFollowedByTryWithFinally(tree)) {
                if (this.toReport.isEmpty() || this.withinTry.size() == this.toReport.size()) {
                    this.toReport.push(new ArrayList());
                }
                this.toReport.peek().add(tree);
            }
        }
    }

    private static boolean isFollowedByTryWithFinally(Tree tree) {
        CFG cfg;
        Tree blockParent;
        for (blockParent = tree.parent(); blockParent != null && !blockParent.is(Tree.Kind.BLOCK); blockParent = blockParent.parent()) {
        }
        if (blockParent != null && !(cfg = CFG.buildCFG(Collections.singletonList(blockParent), true)).blocks().isEmpty()) {
            return TryWithResourcesCheck.newFollowedByTryStatement(cfg.blocks().get(0));
        }
        return false;
    }

    private static boolean newFollowedByTryStatement(CFG.Block cfgBlock) {
        boolean foundNewAutoCloseable = false;
        block5: for (Tree element : cfgBlock.elements()) {
            switch (element.kind()) {
                case NEW_CLASS: {
                    boolean isAutoCloseable = ((NewClassTree)element).symbolType().isSubtypeOf("java.lang.AutoCloseable");
                    if (!isAutoCloseable && foundNewAutoCloseable) {
                        return false;
                    }
                    foundNewAutoCloseable = isAutoCloseable;
                    continue block5;
                }
                case TRY_STATEMENT: {
                    if (((TryStatementTree)element).resourceList().isEmpty() && ((TryStatementTree)element).finallyBlock() != null) {
                        return foundNewAutoCloseable;
                    }
                    return false;
                }
                case VARIABLE: {
                    continue block5;
                }
            }
            if (!foundNewAutoCloseable) continue;
            return false;
        }
        return false;
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.TRY_STATEMENT)) {
            TryStatementTree tryStatementTree = this.withinTry.pop();
            List<Tree> secondaryTrees = this.toReport.pop();
            if (!secondaryTrees.isEmpty()) {
                ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
                for (Tree autoCloseable : secondaryTrees) {
                    secondary.add(new JavaFileScannerContext.Location("AutoCloseable resource", autoCloseable));
                }
                this.reportIssue(tryStatementTree.tryKeyword(), "Change this \"try\" to a try-with-resources." + this.context.getJavaVersion().java7CompatibilityMessage(), secondary, null);
            }
        }
    }

    private boolean withinStandardTryWithFinally() {
        return !this.withinTry.isEmpty() && this.withinTry.peek().resourceList().isEmpty() && this.withinTry.peek().finallyBlock() != null;
    }

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

