/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1607")
public class IgnoredTestsCheck
extends IssuableSubscriptionVisitor {
    private static final String ORG_JUNIT_ASSUME = "org.junit.Assume";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final MethodMatchers ASSUME_METHODS = MethodMatchers.create().ofTypes("org.junit.Assume").names("assumeTrue", "assumeFalse").addParametersMatcher("boolean").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        BlockTree block;
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata symbolMetadata = methodTree.symbol().metadata();
        boolean hasIgnoreAnnotation = IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.Ignore");
        boolean hasDisabledAnnotation = IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.jupiter.api.Disabled");
        if (hasIgnoreAnnotation || hasDisabledAnnotation) {
            this.reportIssue(methodTree.simpleName(), String.format("Either add an explanation about why this test is skipped or remove the \"@%s\" annotation.", hasIgnoreAnnotation ? "Ignore" : "Disabled"));
        }
        if ((block = methodTree.block()) != null) {
            block.body().stream().filter(s -> s.is(Tree.Kind.EXPRESSION_STATEMENT)).map(s -> ((ExpressionStatementTree)s).expression()).filter(s -> s.is(Tree.Kind.METHOD_INVOCATION)).map(MethodInvocationTree.class::cast).filter(ASSUME_METHODS::matches).filter(IgnoredTestsCheck::hasConstantOppositeArg).forEach(mit -> {
                List<JavaFileScannerContext.Location> secondaryLocation = Collections.singletonList(new JavaFileScannerContext.Location("A constant boolean value is passed as argument, causing this test to always be skipped.", mit.arguments()));
                this.reportIssue(ExpressionUtils.methodName(mit), "This assumption is called with a boolean constant; remove it or, to skip this test use an @Ignore/@Disabled annotation in combination with an explanation about why it is skipped.", secondaryLocation, null);
            });
        }
    }

    private static boolean isSilentlyIgnored(SymbolMetadata symbolMetadata, String fullyQualifiedName) {
        for (SymbolMetadata.AnnotationInstance annotation : symbolMetadata.annotations()) {
            Type type = annotation.symbol().type();
            if (type.isUnknown()) {
                return false;
            }
            if (!type.is(fullyQualifiedName)) continue;
            return annotation.values().isEmpty();
        }
        return false;
    }

    private static boolean hasConstantOppositeArg(MethodInvocationTree mit) {
        Optional<Boolean> result = ((ExpressionTree)mit.arguments().get(0)).asConstant(Boolean.class);
        return result.isPresent() && !result.get().equals(mit.symbol().name().contains("True"));
    }
}

