/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.ejb;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;

@Rule(key="S3281")
public class DefaultInterceptorsLocationCheck
extends SimpleXPathBasedCheck {
    private XPathExpression defaultInterceptorClassesExpression = this.getXPathExpression("ejb-jar/assembly-descriptor/interceptor-binding[ejb-name=\"*\"]/interceptor-class");

    @Override
    public void scanFile(XmlFile file) {
        if ("ejb-jar.xml".equalsIgnoreCase(file.getInputFile().filename())) {
            return;
        }
        this.evaluateAsList(this.defaultInterceptorClassesExpression, file.getNamespaceUnawareDocument()).forEach(node -> this.reportIssue((Node)node, "Move this default interceptor to \"ejb-jar.xml\""));
    }
}

