/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import javax.xml.xpath.XPathExpression;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;

@Rule(key="S3421")
public class DeprecatedPomPropertiesCheck
extends SimpleXPathBasedCheck {
    private static final String POM_PROPERTY_PREFIX = "${pom.";
    private static final String POM_PROPERTY_SUFFIX = "}";
    private XPathExpression textsExpression = this.getXPathExpression("//*[text()]");

    @Override
    public void scanFile(XmlFile file) {
        if (!"pom.xml".equalsIgnoreCase(file.getInputFile().filename())) {
            return;
        }
        this.evaluateAsList(this.textsExpression, file.getDocument()).forEach(this::checkText);
    }

    private void checkText(Node textNode) {
        XmlFile.children(textNode).stream().filter(node -> node.getNodeType() == 3).forEach(node -> {
            String text = node.getNodeValue();
            while (StringUtils.contains(text, POM_PROPERTY_PREFIX)) {
                String property = DeprecatedPomPropertiesCheck.extractPropertyName(text);
                this.reportIssue((Node)node, "Replace \"pom." + property + "\" with \"project." + property + "\".");
                text = DeprecatedPomPropertiesCheck.skipFirstProperty(text);
            }
        });
    }

    private static String skipFirstProperty(String text) {
        return text.substring(text.indexOf(POM_PROPERTY_SUFFIX, text.indexOf(POM_PROPERTY_PREFIX)));
    }

    private static String extractPropertyName(String text) {
        String property = text.substring(text.indexOf(POM_PROPERTY_PREFIX) + POM_PROPERTY_PREFIX.length());
        return property.substring(0, property.indexOf(POM_PROPERTY_SUFFIX));
    }
}

