/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.Preconditions;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.tree.Tree;

public class ExplodedGraph {
    private final Map<Node, Node> nodes = new HashMap<Node, Node>();
    private final Map<ProgramPoint, List<Node>> nodesByProgramPoint = new HashMap<ProgramPoint, List<Node>>();

    public Node node(ProgramPoint programPoint, @Nullable ProgramState programState) {
        Node result = new Node(programPoint, programState, this);
        Node cached = this.nodes.get(result);
        if (cached != null) {
            cached.isNew = false;
            return cached;
        }
        result.isNew = true;
        this.nodes.put(result, result);
        this.nodesByProgramPoint.computeIfAbsent(programPoint, k -> new LinkedList()).add(result);
        return result;
    }

    public Map<Node, Node> nodes() {
        return this.nodes;
    }

    public static final class Node {
        public final ProgramPoint programPoint;
        @Nullable
        public final ProgramState programState;
        private final Map<Node, Edge> edges = new HashMap<Node, Edge>();
        private boolean isNew;
        boolean exitPath = false;
        private final int hashcode;
        private final ExplodedGraph explodedGraph;

        private Node(ProgramPoint programPoint, @Nullable ProgramState programState, ExplodedGraph explodedGraph) {
            Objects.requireNonNull(programPoint);
            this.programPoint = programPoint;
            this.programState = programState;
            this.explodedGraph = explodedGraph;
            this.hashcode = programPoint.hashCode() * 31 + (programState == null ? 0 : programState.hashCode());
        }

        public void addParent(@Nullable Node parent, @Nullable MethodYield methodYield) {
            if (parent == null) {
                return;
            }
            Edge edge = this.edges.computeIfAbsent(parent, p -> new Edge(this, (Node)p));
            if (methodYield != null) {
                Preconditions.checkState(parent.programPoint.syntaxTree().is(Tree.Kind.METHOD_INVOCATION), "Yield on edge where parent is not MIT");
                edge.yields.add(methodYield);
            }
        }

        public Collection<Node> siblings() {
            Collection collection = this.explodedGraph.nodesByProgramPoint.getOrDefault(this.programPoint, Collections.emptyList());
            collection.remove(this);
            return collection;
        }

        @Nullable
        public Node parent() {
            return this.parents().stream().findFirst().orElse(null);
        }

        public Set<Node> parents() {
            return this.edges.keySet();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node other = (Node)obj;
                return this.programPoint.equals(other.programPoint) && Objects.equals(this.programState, other.programState);
            }
            return false;
        }

        public String toString() {
            return "B" + this.programPoint.block.id() + "." + this.programPoint.i + ": " + this.programState;
        }

        public Collection<Edge> edges() {
            return this.edges.values();
        }

        public boolean isNew() {
            return this.isNew;
        }
    }

    public static final class Edge {
        final Node child;
        final Node parent;
        final int hashcode;
        private Set<LearnedConstraint> lc;
        private Set<LearnedAssociation> la;
        private final Set<MethodYield> yields = new LinkedHashSet<MethodYield>();

        private Edge(Node child, Node parent) {
            Preconditions.checkState(!child.equals(parent));
            this.child = child;
            this.parent = parent;
            this.hashcode = Objects.hash(child, parent);
        }

        public Node child() {
            return this.child;
        }

        public Node parent() {
            return this.parent;
        }

        public Set<LearnedConstraint> learnedConstraints() {
            if (this.lc == null) {
                this.lc = this.child.programState.learnedConstraints(this.parent.programState);
            }
            return this.lc;
        }

        public Set<LearnedAssociation> learnedAssociations() {
            if (this.la == null) {
                this.la = this.child.programState.learnedAssociations(this.parent.programState);
            }
            return this.la;
        }

        public Set<MethodYield> yields() {
            return this.yields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.child.equals(edge.child) && this.parent.equals(edge.parent);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

