/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.AnalysisException;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.collections.CollectionUtils;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.model.JParserConfig;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class JavaFrontend {
    private static final Logger LOG = Loggers.get(JavaFrontend.class);
    private final JavaVersion javaVersion;
    private final SonarComponents sonarComponents;
    private final List<File> globalClasspath;
    private final JavaAstScanner astScanner;
    private final JavaAstScanner astScannerForTests;
    private final JavaAstScanner astScannerForGeneratedFiles;

    public JavaFrontend(JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, JavaCheck ... visitors) {
        this.javaVersion = javaVersion;
        this.sonarComponents = sonarComponents;
        ArrayList<JavaCheck> commonVisitors = new ArrayList<JavaCheck>();
        commonVisitors.add(javaResourceLocator);
        if (postAnalysisIssueFilter != null) {
            commonVisitors.add(postAnalysisIssueFilter);
        }
        List<JavaCheck> codeVisitors = ListUtils.concat(new List[]{commonVisitors, Arrays.asList(visitors)});
        ArrayList<JavaCheck> testCodeVisitors = new ArrayList<JavaCheck>(commonVisitors);
        if (measurer != null) {
            List<Measurer> measurers = Collections.singletonList(measurer);
            codeVisitors = ListUtils.concat(new Iterable[]{measurers, codeVisitors});
            testCodeVisitors.add(measurer.new Measurer.TestFileMeasurer());
        }
        ArrayList<File> classpath = new ArrayList();
        ArrayList<File> testClasspath = new ArrayList();
        ArrayList<JavaCheck> jspCodeVisitors = new ArrayList();
        ArrayList<File> jspClasspath = new ArrayList();
        if (sonarComponents != null) {
            if (!sonarComponents.isSonarLintContext()) {
                codeVisitors = ListUtils.concat(new Iterable[]{codeVisitors, Arrays.asList(new FileLinesVisitor(sonarComponents), new SyntaxHighlighterVisitor(sonarComponents))});
                testCodeVisitors.add(new SyntaxHighlighterVisitor(sonarComponents));
            }
            classpath = sonarComponents.getJavaClasspath();
            testClasspath = sonarComponents.getJavaTestClasspath();
            jspClasspath = sonarComponents.getJspClasspath();
            testCodeVisitors.addAll(sonarComponents.testChecks());
            jspCodeVisitors = sonarComponents.jspChecks();
        }
        this.globalClasspath = Stream.of(classpath, testClasspath, jspClasspath).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.astScanner = new JavaAstScanner(sonarComponents);
        this.astScanner.setVisitorBridge(JavaFrontend.createVisitorBridge(codeVisitors, classpath, javaVersion, sonarComponents));
        this.astScannerForTests = new JavaAstScanner(sonarComponents);
        this.astScannerForTests.setVisitorBridge(JavaFrontend.createVisitorBridge(testCodeVisitors, testClasspath, javaVersion, sonarComponents));
        this.astScannerForGeneratedFiles = new JavaAstScanner(sonarComponents);
        this.astScannerForGeneratedFiles.setVisitorBridge(JavaFrontend.createVisitorBridge(jspCodeVisitors, jspClasspath, javaVersion, sonarComponents));
    }

    private static VisitorsBridge createVisitorBridge(Iterable<JavaCheck> codeVisitors, List<File> classpath, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents) {
        VisitorsBridge visitorsBridge = new VisitorsBridge(codeVisitors, classpath, sonarComponents);
        visitorsBridge.setJavaVersion(javaVersion);
        return visitorsBridge;
    }

    @VisibleForTesting
    boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    public void scan(Iterable<InputFile> sourceFiles, Iterable<InputFile> testFiles, Iterable<? extends InputFile> generatedFiles) {
        if (this.isBatchModeEnabled()) {
            this.scanAsBatch(sourceFiles, testFiles);
        } else {
            JavaFrontend.scanAndMeasureTask(sourceFiles, this.astScanner::scan, "Main");
            JavaFrontend.scanAndMeasureTask(testFiles, this.astScannerForTests::scan, "Test");
            JavaFrontend.scanAndMeasureTask(generatedFiles, this.astScannerForGeneratedFiles::scan, "Generated");
        }
    }

    private void scanAsBatch(Iterable<InputFile> ... sourceFiles) {
        block6: {
            try {
                ArrayList allFiles = new ArrayList();
                Arrays.stream(sourceFiles).forEach(files -> files.forEach(allFiles::add));
                try {
                    JParserConfig.Mode.BATCH.create(JParserConfig.effectiveJavaVersion(this.javaVersion), this.globalClasspath).parse(allFiles, this::analysisCancelled, this::scanAsBatchCallback);
                }
                finally {
                    this.astScanner.endOfAnalysis();
                    this.astScannerForTests.endOfAnalysis();
                    this.astScannerForGeneratedFiles.endOfAnalysis();
                }
            }
            catch (AnalysisException e) {
                throw e;
            }
            catch (Exception e) {
                this.astScanner.checkInterrupted(e);
                LOG.error("Batch Mode failed, analysis of Java Files stopped.", (Throwable)e);
                if (!this.astScanner.shouldFailAnalysis()) break block6;
                throw new AnalysisException("Batch Mode failed, analysis of Java Files stopped.", e);
            }
        }
    }

    private void scanAsBatchCallback(InputFile inputFile, JParserConfig.Result result) {
        JavaAstScanner scanner = inputFile.type() == InputFile.Type.TEST ? this.astScannerForTests : this.astScanner;
        PerformanceMeasure.Duration duration = PerformanceMeasure.start(inputFile.type() == InputFile.Type.TEST ? "Test" : "Main");
        scanner.simpleScan(inputFile, result, ast -> {});
        duration.stop();
    }

    private boolean isBatchModeEnabled() {
        return this.sonarComponents != null && this.sonarComponents.isBatchModeEnabled();
    }

    private static <T> void scanAndMeasureTask(Iterable<T> files, Consumer<Iterable<T>> action, String descriptor) {
        if (CollectionUtils.size(files) > 0) {
            PerformanceMeasure.Duration mainDuration = PerformanceMeasure.start(descriptor);
            Profiler profiler = Profiler.create((Logger)LOG).startInfo(String.format("Java \"%s\" source files AST scan", descriptor));
            action.accept(files);
            profiler.stopInfo();
            mainDuration.stop();
        } else {
            LOG.info(String.format("No \"%s\" source files to scan.", descriptor));
        }
    }
}

